package cn.com.duibaboot.ext.autoconfigure.flowreplay.record.aop;

import cn.com.duibaboot.ext.autoconfigure.flowreplay.CustomizeFlowReplaySpan;
import cn.com.duiba.boot.flowreplay.FlowReplayCustomizeSpan;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.FlowReplayTrace;
import lombok.extern.slf4j.Slf4j;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;

import java.lang.reflect.Method;

/**
 * FlowReplayCustomizeSpan 注解切面，用于实际的录制
 * Created by guoyanfei .
 * 2019-05-23 .
 */
@Slf4j
@Aspect
public class RecordCustomizeFlowReplaySpanPlugin {

    @Around("execution(* *.*(..)) && @annotation(cn.com.duiba.boot.flowreplay.FlowReplayCustomizeSpan)")
    public Object customizeJoinPoint(ProceedingJoinPoint joinPoint) throws Throwable {
        MethodSignature signature = (MethodSignature) joinPoint.getSignature();
        FlowReplayCustomizeSpan customizeSpan = signature.getMethod().getAnnotation(FlowReplayCustomizeSpan.class);
        if (customizeSpan == null || !FlowReplayTrace.isTraced()) {
            return joinPoint.proceed();
        }
        // 本次调用已经被标记为需要忽略，不录制
        if (IgnoreSubInvokesContext.isMarked()) {
            return joinPoint.proceed();
        }
        Method method = signature.getMethod();
        Object[] parameterValues = joinPoint.getArgs();
        Object obj = joinPoint.getTarget();
        // 标记本次调用的子调用不需要录制
        IgnoreSubInvokesContext.instMark(obj, method.getName(), parameterValues);

        Object ret;
        try {
            ret = joinPoint.proceed();
        } catch (Throwable t) {
            // 如果捕捉到异常，并且正在录制中，那么不录这个用例
            FlowReplayTrace.remove();
            IgnoreSubInvokesContext.unmark();
            throw t;
        }

        try {
            CustomizeFlowReplaySpan span = CustomizeFlowReplaySpan.createSpan(signature, parameterValues, ret);
            span.setTraceId(FlowReplayTrace.getCurrentTraceId());
            FlowReplayTrace.addSubSpan(span);
            log.debug("Customize录制_traceId={}_spanId={}", span.getTraceId(), span.getSpanId());
        } catch (Throwable t) {
            log.error("Customize_录制异常", t);
        } finally {
            IgnoreSubInvokesContext.unmark();
        }
        return ret;
    }
}
