package cn.com.duibaboot.ext.autoconfigure.flowreplay.replay.replayer;

import cn.com.duibaboot.ext.autoconfigure.flowreplay.FlowReplayException;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.FlowReplaySpan;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.FlowReplayTrace;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.replay.ReplayContextHolder;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.replay.ReplayTraceResult;
import lombok.extern.slf4j.Slf4j;

import javax.annotation.Resource;
import java.util.concurrent.atomic.AtomicInteger;

/**
 * 实际操作的回放器
 * Created by guoyanfei .
 * 2019-02-26 .
 */
@Slf4j
public class ConcreateReplayer implements Replayer {

    @Resource
    private RemoteServiceReplayer remoteServiceReplayer;

    @Resource
    private SpringMvcReplayer springMvcReplayer;

    /**
     * 当前正在回放的trace计数
     */
    private final AtomicInteger currentReplayingTraceCount = new AtomicInteger(0);

    @Override
    public ReplayTraceResult replay(FlowReplayTrace trace) {    // NOSONAR
        if (trace.getSecondsAfterStart() != null) {
            long traceTimestamp = ReplayContextHolder.calculateTraceTimestamp(trace.getSecondsAfterStart());
            if (!ReplayContextHolder.isMockSysTimeValid(traceTimestamp)) {
                while (true) {
                    if (currentReplayingTraceCount.get() == 0) {
                        ReplayContextHolder.setMockSysTime(traceTimestamp);
                        break;
                    }
                    try {
                        Thread.sleep(100); // 每隔 100毫秒 检查一次
                    } catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                    if (Thread.currentThread().isInterrupted()) {
                        break;
                    }
                }
            }
        }
        FlowReplaySpan mainSpan = trace.getMainSpan();
        if (mainSpan == null) {
            throw new FlowReplayException("无效的trace_traceId_" + trace.getTraceId());
        }
        try {
            currentReplayingTraceCount.incrementAndGet();
            switch (mainSpan.getSpanType()) {
                case REMOTE_SERVICE:
                    return remoteServiceReplayer.replay(trace);
                case SPRING_MVC:
                    return springMvcReplayer.replay(trace);
                default:
                    throw new FlowReplayException("暂不支持的回放类型_traceId_" + trace.getTraceId());
            }
        } finally {
            currentReplayingTraceCount.decrementAndGet();
        }
    }
}
