package cn.com.duibaboot.ext.autoconfigure.httpclient.ssre;

import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.HttpContext;

import java.io.IOException;

/**
 * 只允许访问外网
 */
public class SsreHttpClientWrapper extends CloseableHttpClient implements ClientWrapper{

    private CloseableHttpClient client;

    @Override
    protected  CloseableHttpResponse doExecute(HttpHost target, HttpRequest request, HttpContext context) throws IOException{
        SsreUtils.checkSsre(target);
        return client.execute(target,request,context);
    }

    @Override
    public void close() throws IOException {
        client.close();
    }

    @Override
    public HttpParams getParams() {
        return client.getParams();
    }

    @Override
    public ClientConnectionManager getConnectionManager() {
        return client.getConnectionManager();
    }

    @Override
    public boolean trySetClient(Object client) {
        if(client==null || !CloseableHttpClient.class.isAssignableFrom(client.getClass())){
            return false;
        }
        this.client = (CloseableHttpClient)client;
        return true;
    }

    @Override
    public Class acceptableClass() {
        return HttpClient.class;
    }

}
