package cn.com.duibaboot.ext.autoconfigure.monitor.elasticjob;

import cn.com.duiba.boot.event.MainContextRefreshedEvent;
import io.elasticjob.lite.api.JobScheduler;
import io.elasticjob.lite.config.LiteJobConfiguration;
import io.elasticjob.lite.internal.config.LiteJobConfigurationGsonFactory;
import io.elasticjob.lite.internal.schedule.JobRegistry;
import io.elasticjob.lite.internal.storage.JobNodePath;
import io.elasticjob.lite.reg.base.CoordinatorRegistryCenter;
import io.elasticjob.lite.reg.zookeeper.ZookeeperConfiguration;
import io.elasticjob.lite.reg.zookeeper.ZookeeperRegistryCenter;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.EventListener;
import org.springframework.util.ReflectionUtils;

import java.lang.reflect.Field;
import java.util.Map;

/**
 * @author: <a href="http://www.panaihua.com">panaihua</a>
 * @date: 2019-08-22 20:23
 * @descript:
 * @version: 1.0
 */
@Slf4j
@Configuration
@ConditionalOnClass(JobScheduler.class)
public class ElasticjobMonitorAutoConfiguration {

    @Autowired
    private ElasticjobMonitorManager elasticjobMonitorManager;

    @EventListener(MainContextRefreshedEvent.class)
    public void init() {

        JobRegistry jobRegistry = JobRegistry.getInstance();
        if (jobRegistry == null) {
            return;
        }

        try {

            Field regCenterMapField = ReflectionUtils.findField(JobRegistry.class, "regCenterMap");
            ReflectionUtils.makeAccessible(regCenterMapField);
            Map<String, CoordinatorRegistryCenter> centerMap = (Map<String, CoordinatorRegistryCenter>) ReflectionUtils.getField(regCenterMapField, jobRegistry);
            if (centerMap == null || centerMap.size() == 0) {
                return;
            }

            boolean isSetJobName = false;
            for (Map.Entry<String, CoordinatorRegistryCenter> entry : centerMap.entrySet()) {

                ZookeeperRegistryCenter center = (ZookeeperRegistryCenter) entry.getValue();

                if (!isSetJobName) {

                    Field zkConfigField = ReflectionUtils.findField(ZookeeperRegistryCenter.class, "zkConfig");
                    ReflectionUtils.makeAccessible(zkConfigField);
                    ZookeeperConfiguration configuration = (ZookeeperConfiguration) ReflectionUtils.getField(zkConfigField, center);
                    elasticjobMonitorManager.setJobNamespace(configuration.getNamespace());
                    isSetJobName = true;
                }

                String jobName = entry.getKey();
                JobNodePath jobNodePath = new JobNodePath(jobName);
                String json = center.getDirectly(jobNodePath.getConfigNodePath());
                LiteJobConfiguration liteJobConfiguration = LiteJobConfigurationGsonFactory.fromJson(json);
                elasticjobMonitorManager.putJobCronMap(jobName, liteJobConfiguration.getTypeConfig().getCoreConfig().getCron());
            }


        } catch (Exception e) {
            log.info("初始化作业的信息异常", e);
        }
    }

    @Configuration
    public static class ElasticjobMonitorEndpointConfiguration {
        @Bean
        public ElasticjobMonitorMvcEndpoint elasticjobMonitorEndpointConfiguration() {
            return new ElasticjobMonitorMvcEndpoint();
        }
    }

    @Configuration
    public static class ElasticjobMonitorManagerConfiguration {
        @Bean
        public ElasticjobMonitorManager elasticjobMonitorManagerConfiguration() {
            return new ElasticjobMonitorManager();
        }
    }
}
