/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.flowreplay;

import cn.com.duiba.wolf.utils.UUIDUtils;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.FlowReplaySpan;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.SpanType;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.serializer.KryoSerializer;
import java.lang.reflect.Method;
import org.aspectj.lang.reflect.MethodSignature;

public class RocketMqProducerFlowReplaySpan
extends FlowReplaySpan {
    private static final long serialVersionUID = 6683902243547622289L;
    private String methodName;
    private String[] parameterTypes;
    private byte[] parameterValues;
    private String returnType;
    private byte[] returnValue;
    private String typeFullPath;

    @Override
    public SpanType getSpanType() {
        return SpanType.ROCKETMQ;
    }

    public static RocketMqProducerFlowReplaySpan createSpan(MethodSignature methodSignature, Object[] parameterValues) {
        Method method = methodSignature.getMethod();
        Class<?>[] parameterTypes = method.getParameterTypes();
        String[] parameterTypeNames = null;
        if (parameterTypes.length > 0) {
            parameterTypeNames = new String[parameterTypes.length];
            for (int i = 0; i < parameterTypes.length; ++i) {
                parameterTypeNames[i] = parameterTypes[i].getName();
            }
        }
        Class returnTypeClass = methodSignature.getReturnType();
        RocketMqProducerFlowReplaySpan span = new RocketMqProducerFlowReplaySpan();
        span.setSpanId(UUIDUtils.createUUID());
        span.methodName = method.getName();
        span.parameterTypes = parameterTypeNames;
        span.parameterValues = KryoSerializer.serialize(parameterValues);
        span.returnType = returnTypeClass != null ? returnTypeClass.getName() : null;
        span.typeFullPath = methodSignature.getDeclaringTypeName();
        return span;
    }

    public void setReturnValue(Object ret) {
        this.returnValue = KryoSerializer.serialize(ret);
    }

    public String getMethodName() {
        return this.methodName;
    }

    public String[] getParameterTypes() {
        return this.parameterTypes;
    }

    public Object[] getParameterValues() {
        return (Object[])KryoSerializer.deserialize(this.parameterValues);
    }

    public Object getReturnValue() {
        return KryoSerializer.deserialize(this.returnValue);
    }

    public String getReturnType() {
        return this.returnType;
    }

    public String getTypeFullPath() {
        return this.typeFullPath;
    }
}

