/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.flowreplay.replay;

import cn.com.duiba.wolf.threadpool.NamedThreadFactory;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.FlowReplaySpan;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.FlowReplayTrace;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.RemoteServiceFlowReplaySpan;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.SpringMvcFlowReplaySpan;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.replay.ReplayContext;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.replay.ReplayContextHolder;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.replay.ReplayTraceResult;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.replay.event.ReplayEndEvent;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.replay.event.ReplayStartEvent;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.replay.replayer.Replayer;
import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;

public class ReplayTraceReplayer {
    private static final Logger log = LoggerFactory.getLogger(ReplayTraceReplayer.class);
    @Resource
    private Replayer replayer;
    private volatile ExecutorService replayerThreadPool;
    private volatile Thread replayThread;

    @EventListener(value={ReplayStartEvent.class})
    public void replayStartEventListener(ReplayStartEvent event) {
        this.replayThread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ReplayContext context = ReplayContextHolder.getReplayContext();
                if (context == null) {
                    return;
                }
                int replayThreadPoolSize = context.getReplayThreadPoolSize();
                ReplayTraceReplayer.this.replayerThreadPool = Executors.newFixedThreadPool(replayThreadPoolSize, (ThreadFactory)new NamedThreadFactory("replay", true));
                try {
                    ArrayList futures = new ArrayList(replayThreadPoolSize);
                    for (int i = 0; i < replayThreadPoolSize; ++i) {
                        try {
                            Thread.sleep(2000L);
                        }
                        catch (InterruptedException interruptedException) {
                            Thread.currentThread().interrupt();
                        }
                        if (Thread.currentThread().isInterrupted()) break;
                        futures.add(ReplayTraceReplayer.this.replayerThreadPool.submit(new ReplayerThread(context)));
                    }
                    for (Future future : futures) {
                        try {
                            log.debug("\u5f15\u6d41\u56de\u5f52_\u5f00\u59cb\u7b49\u5f85\u56de\u653e\u7ed3\u679c_reportId_{}", (Object)context.getReportId());
                            future.get();
                        }
                        catch (Exception e) {
                            log.error("\u5f15\u6d41\u56de\u5f52_ReplayerThread_Future_get_error", (Throwable)e);
                        }
                    }
                }
                finally {
                    context.replayersDone();
                }
            }
        }, "DBThread-Replay-Replayer");
        this.replayThread.start();
    }

    @EventListener(value={ReplayEndEvent.class})
    public void replayEndEventListener(ReplayEndEvent event) {
        if (this.replayerThreadPool != null) {
            this.replayerThreadPool.shutdownNow();
        }
        if (this.replayThread != null) {
            this.replayThread.interrupt();
        }
    }

    private class ReplayerThread
    implements Runnable {
        private ReplayContext context;

        public ReplayerThread(ReplayContext context) {
            this.context = context;
        }

        @Override
        public void run() {
            try {
                this.replay();
            }
            catch (Exception e) {
                log.error("\u5f15\u6d41\u56de\u5f52_\u56de\u653e\u5668\u7ebf\u7a0b\u5f02\u5e38_reportId_{}", (Object)this.context.getReportId(), (Object)e);
                ReplayContextHolder.forceEnd();
            }
        }

        private void replay() {
            while (!this.context.isTracesLoadFinished() || !this.context.isTraceQueueEmpty()) {
                try {
                    FlowReplayTrace trace = this.context.pollTrace();
                    if (trace == null || this.isMasked(trace)) continue;
                    ReplayTraceResult traceResult = ReplayTraceReplayer.this.replayer.replay(trace);
                    this.context.putResult(traceResult);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                catch (Exception e) {
                    log.error("\u5f15\u6d41\u56de\u5f52_\u5355\u4e2a\u7528\u4f8b\u56de\u653e\u5f02\u5e38_reportId_{}", (Object)this.context.getReportId(), (Object)e);
                }
                if (!Thread.currentThread().isInterrupted()) continue;
                break;
            }
        }

        private boolean isMasked(FlowReplayTrace trace) {
            return this.isMaskedApiTrace(trace) || ReplayContextHolder.isMaskedTraceIds(trace.getTraceId());
        }

        private boolean isMaskedApiTrace(FlowReplayTrace trace) {
            FlowReplaySpan mainSpan = trace.getMainSpan();
            if (mainSpan instanceof SpringMvcFlowReplaySpan) {
                SpringMvcFlowReplaySpan springMvcFlowReplaySpan = (SpringMvcFlowReplaySpan)mainSpan;
                return ReplayContextHolder.isMaskedApi(springMvcFlowReplaySpan.getSpringBestMatchingUri());
            }
            if (mainSpan instanceof RemoteServiceFlowReplaySpan) {
                RemoteServiceFlowReplaySpan remoteServiceFlowReplaySpan = (RemoteServiceFlowReplaySpan)mainSpan;
                return ReplayContextHolder.isMaskedApi(remoteServiceFlowReplaySpan.getApiName());
            }
            return false;
        }
    }
}

