/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.threadpool;

import cn.com.duiba.wolf.concurrent.AbortPolicyWithReport;
import cn.com.duiba.wolf.threadpool.NamedThreadFactory;
import cn.com.duibaboot.ext.autoconfigure.threadpool.ThreadPoolProperties;
import cn.com.duibaboot.ext.autoconfigure.threadpool.wrapper.ScheduledThreadPoolExecutorWrapper;
import cn.com.duibaboot.ext.autoconfigure.threadpool.wrapper.ThreadPoolExecutorWrapper;
import java.util.AbstractQueue;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.core.Ordered;
import org.springframework.scheduling.concurrent.ThreadPoolExecutorFactoryBean;

@Configuration
@ConditionalOnClass(value={ThreadPoolExecutorFactoryBean.class})
@EnableConfigurationProperties(value={ThreadPoolProperties.class})
public class ThreadPoolAutoConfiguration {
    private static Logger logger = LoggerFactory.getLogger(ThreadPoolAutoConfiguration.class);
    @Resource
    private ThreadPoolProperties threadPoolProperties;

    @Bean(name={"executorService"}, destroyMethod="shutdown")
    @ConditionalOnProperty(name={"duiba.threadpool.enabled"}, havingValue="true", matchIfMissing=false)
    public ExecutorService executorService() {
        int queueSize = this.threadPoolProperties.getQueueSize();
        AbstractQueue queue = queueSize == 0 ? new SynchronousQueue() : new ArrayBlockingQueue(queueSize);
        int maxSize = Math.max(this.threadPoolProperties.getMaxSize(), this.threadPoolProperties.getCoreSize());
        ThreadPoolExecutor threadPool = new ThreadPoolExecutor(this.threadPoolProperties.getCoreSize(), maxSize, 60L, TimeUnit.SECONDS, (BlockingQueue<Runnable>)((Object)queue), (ThreadFactory)new NamedThreadFactory("DuibaBiz"), (RejectedExecutionHandler)new AbortPolicyWithReport());
        return new ThreadPoolExecutorWrapper(threadPool, this.threadPoolProperties.getShutdownTimeout());
    }

    @Bean(name={"scheduledExecutorService"}, destroyMethod="shutdown")
    @ConditionalOnProperty(name={"duiba.threadpool.scheduled.enabled"}, havingValue="true", matchIfMissing=false)
    public ScheduledExecutorService scheduledExecutorService() {
        ScheduledThreadPoolExecutor scheduledThreadPool = new ScheduledThreadPoolExecutor(this.threadPoolProperties.getScheduled().getCoreSize(), (ThreadFactory)new NamedThreadFactory("DuibaBizScheduled"), (RejectedExecutionHandler)new AbortPolicyWithReport());
        return new ScheduledThreadPoolExecutorWrapper(scheduledThreadPool, this.threadPoolProperties.getScheduled().getShutdownTimeout());
    }

    @Configuration
    public static class DuibaUncaughtExceptionHandlerConfiguarApplicationListener
    implements ApplicationListener<ContextRefreshedEvent>,
    Ordered {
        private boolean flag = true;

        public void onApplicationEvent(ContextRefreshedEvent applicationStartedEvent) {
            if (this.flag) {
                if (Thread.getDefaultUncaughtExceptionHandler() == null) {
                    Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

                        @Override
                        public void uncaughtException(Thread t, Throwable e) {
                            logger.error("Thread[" + t.getId() + "," + t.getName() + "] caught error:", e);
                        }
                    });
                }
                this.flag = false;
            }
        }

        public int getOrder() {
            return -15;
        }
    }
}

