/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.logger;

import ch.qos.logback.classic.AsyncAppender;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.encoder.PatternLayoutEncoder;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.FileAppender;
import ch.qos.logback.core.encoder.Encoder;
import ch.qos.logback.core.pattern.PatternLayoutEncoderBase;
import cn.com.duibaboot.ext.autoconfigure.logger.logback.appender.KafkaAppender;
import cn.com.duibaboot.ext.autoconfigure.logger.logback.appender.KafkaAppenderProperties;
import cn.com.duibaboot.ext.autoconfigure.perftest.PerfTestRoutingDataSource;
import com.google.common.collect.ArrayListMultimap;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import org.aopalliance.aop.Advice;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.dbcp2.BasicDataSource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.MethodBeforeAdvice;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnResource;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.context.event.EventListener;
import org.springframework.core.io.ClassPathResource;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.util.ReflectionUtils;

@Configuration
@ConditionalOnClass(value={LoggerContext.class})
public class LoggerAutoConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(LoggerAutoConfiguration.class);

    @Bean
    @ConditionalOnResource(resources={"/logback/loginsight-logback.xml"})
    public ApplicationListener loginsightLoggerConfiguar() {
        return new ApplicationListener<ContextRefreshedEvent>(){
            private boolean flag = true;

            public void onApplicationEvent(ContextRefreshedEvent applicationStartedEvent) {
                if (this.flag) {
                    try {
                        LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
                        JoranConfigurator configurator = new JoranConfigurator();
                        configurator.setContext((Context)loggerContext);
                        configurator.doConfigure(new ClassPathResource("/logback/loginsight-logback.xml").getInputStream());
                        Appender loginsightAppender = loggerContext.getLogger("loginsight_log").getAppender("ASYNC_LOGINSIGHT_APPENDER");
                        loggerContext.getLogger("ROOT").addAppender(loginsightAppender);
                    }
                    catch (Exception e) {
                        logger.error(e.getMessage(), (Throwable)e);
                    }
                    this.flag = false;
                }
            }
        };
    }

    @Bean
    public ApplicationListener ReplaceEncoderConfiguar() {
        return new ApplicationListener<ContextRefreshedEvent>(){
            private Timer timer = new Timer("logback-flusher");
            private ConcurrentHashMap<String, OutputStream> outputStreamMapping = new ConcurrentHashMap();
            private static final int intevalPeriod = 5000;
            private static final int timeDelay = 5000;
            private boolean flag = true;
            TimerTask timerTask = new TimerTask(){

                @Override
                public void run() {
                    for (OutputStream os : outputStreamMapping.values()) {
                        if (os == null) continue;
                        try {
                            os.flush();
                        }
                        catch (IOException e) {
                            logger.error(e.getMessage(), (Throwable)e);
                        }
                    }
                }
            };

            public void onApplicationEvent(ContextRefreshedEvent applicationStartedEvent) {
                if (this.flag) {
                    LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
                    List loggers = loggerContext.getLoggerList();
                    for (ch.qos.logback.classic.Logger logger : loggers) {
                        Iterator iter = logger.iteratorForAppenders();
                        while (iter.hasNext()) {
                            FileAppender fileAppender;
                            Encoder encoder;
                            AsyncAppender asyncAppender;
                            Iterator iteratorForAppenders;
                            Appender appender = (Appender)iter.next();
                            if (appender instanceof AsyncAppender && (iteratorForAppenders = (asyncAppender = (AsyncAppender)appender).iteratorForAppenders()).hasNext()) {
                                appender = (Appender)iteratorForAppenders.next();
                            }
                            if (!(appender instanceof FileAppender) || (encoder = (fileAppender = (FileAppender)appender).getEncoder()) == null || !(encoder instanceof PatternLayoutEncoder)) continue;
                            Field field = ReflectionUtils.findField(encoder.getClass(), (String)"outputStream");
                            if (field == null) {
                                logger.warn("logback encoder have no field named 'outputStream'.");
                                return;
                            }
                            field.setAccessible(true);
                            OutputStream outputStream = (OutputStream)ReflectionUtils.getField((Field)field, (Object)encoder);
                            String appenderName = fileAppender.getName();
                            if (outputStream != null) {
                                this.outputStreamMapping.put(appenderName, outputStream);
                            }
                            ProxyFactory proxyFactory = new ProxyFactory();
                            proxyFactory.setTarget((Object)encoder);
                            proxyFactory.addAdvice((Advice)new MethodBeforeAdvice(){

                                public void before(Method method, Object[] args, Object target) throws Throwable {
                                    OutputStream outputStream;
                                    if (method.getName() == "init" && (outputStream = (OutputStream)args[0]) != null) {
                                        outputStreamMapping.put(fileAppender.getName(), outputStream);
                                    }
                                }
                            });
                            Encoder newFileEncoder = (Encoder)proxyFactory.getProxy();
                            fileAppender.setEncoder(newFileEncoder);
                        }
                    }
                    this.timer.schedule(this.timerTask, 5000L, 5000L);
                    this.flag = false;
                }
            }
        };
    }

    @Bean
    public ApplicationListener asyncLoggerConfiguar() {
        return new ApplicationListener<ContextRefreshedEvent>(){
            private boolean flag = true;
            private Map<FileAppender, AsyncAppender> syncAppender2asyncAppenderCachedMap = new HashMap<FileAppender, AsyncAppender>();

            public void onApplicationEvent(ContextRefreshedEvent applicationStartedEvent) {
                if (this.flag) {
                    try {
                        LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
                        List loggers = loggerContext.getLoggerList();
                        for (ch.qos.logback.classic.Logger logger : loggers) {
                            this.switchLogAppend2Async(logger);
                        }
                        this.syncAppender2asyncAppenderCachedMap = null;
                    }
                    catch (Exception e) {
                        logger.error(e.getMessage(), (Throwable)e);
                    }
                    this.flag = false;
                }
            }

            private void switchLogAppend2Async(ch.qos.logback.classic.Logger log) {
                Iterator iter = log.iteratorForAppenders();
                ArrayList<AsyncAppender> asyncAppenders2Add = new ArrayList<AsyncAppender>();
                ArrayList<Appender> appenders2Remove = new ArrayList<Appender>();
                while (iter.hasNext()) {
                    Appender appender = (Appender)iter.next();
                    if (!(appender instanceof FileAppender)) continue;
                    AsyncAppender asyncAppender = this.getCachedAsyncAppender((FileAppender)appender);
                    asyncAppenders2Add.add(asyncAppender);
                    appenders2Remove.add(appender);
                }
                for (Appender syncAppender : appenders2Remove) {
                    log.detachAppender(syncAppender);
                }
                for (AsyncAppender asyncAppender : asyncAppenders2Add) {
                    log.addAppender((Appender)asyncAppender);
                }
            }

            private AsyncAppender getCachedAsyncAppender(FileAppender fileAppender) {
                AsyncAppender asyncAppender = this.syncAppender2asyncAppenderCachedMap.get(fileAppender);
                if (asyncAppender == null) {
                    PatternLayoutEncoderBase pencoder;
                    String pattern;
                    asyncAppender = new AsyncAppender();
                    asyncAppender.setContext((Context)((LoggerContext)LoggerFactory.getILoggerFactory()));
                    asyncAppender.setDiscardingThreshold(0);
                    asyncAppender.setQueueSize(512);
                    boolean includeCallerData = false;
                    Encoder encoder = fileAppender.getEncoder();
                    if (encoder != null && encoder instanceof PatternLayoutEncoderBase && ((pattern = (pencoder = (PatternLayoutEncoderBase)encoder).getPattern()).contains("%L") || pattern.contains("%line") || pattern.contains("%C") || pattern.contains("%class") || pattern.contains("%M") || pattern.contains("%method") || pattern.contains("%F") || pattern.contains("%file") || pattern.contains("%caller"))) {
                        includeCallerData = true;
                    }
                    asyncAppender.setIncludeCallerData(includeCallerData);
                    asyncAppender.setName("DuibaBootAutoAsync_" + fileAppender.getName());
                    asyncAppender.addAppender((Appender)fileAppender);
                    asyncAppender.start();
                    this.syncAppender2asyncAppenderCachedMap.put(fileAppender, asyncAppender);
                }
                return asyncAppender;
            }
        };
    }

    @Configuration
    @ConditionalOnClass(value={KafkaTemplate.class})
    @EnableConfigurationProperties(value={KafkaAppenderProperties.class})
    public static class KafkaAppenderConfiguration {
        @Autowired
        private KafkaAppenderProperties kafkaAppenderProperties;
        @Autowired
        private KafkaTemplate kafkaTemplate;
        private boolean flag = true;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @EventListener(value={ContextRefreshedEvent.class})
        public void onApplicationEvent(ContextRefreshedEvent applicationStartedEvent) {
            if (this.flag) {
                try {
                    if (this.kafkaAppenderProperties.getPatterns() == null || this.kafkaAppenderProperties.getPatterns().length == 0) {
                        return;
                    }
                    LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
                    ArrayListMultimap logger2PatternsMap = ArrayListMultimap.create();
                    for (KafkaAppenderProperties.Pattern pattern : this.kafkaAppenderProperties.getPatterns()) {
                        if (StringUtils.isBlank((CharSequence)pattern.getLoggerName())) {
                            throw new IllegalStateException("config `duiba.logback.appender.kafka[*].logger` must not be blank");
                        }
                        if (StringUtils.isBlank((CharSequence)pattern.getTopic())) {
                            throw new IllegalStateException("config `duiba.logback.appender.kafka[*].topic` must not be blank");
                        }
                        logger2PatternsMap.put((Object)pattern.getLoggerName(), (Object)pattern);
                    }
                    for (String loggerName : logger2PatternsMap.keySet()) {
                        Collection patterns = logger2PatternsMap.get((Object)loggerName);
                        if (CollectionUtils.isEmpty((Collection)patterns)) continue;
                        ch.qos.logback.classic.Logger logger = loggerContext.getLogger(loggerName);
                        KafkaAppender appender = new KafkaAppender(this.kafkaTemplate, patterns);
                        appender.setContext((Context)loggerContext);
                        appender.start();
                        logger.addAppender(appender);
                    }
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
                finally {
                    this.flag = false;
                }
            }
        }
    }

    @Configuration
    @ConditionalOnClass(value={BasicDataSource.class, LoggerContext.class})
    public static class dataSourceMonitorConfigurer {
        @Bean(name={"_dataSourceMonitor"})
        public DataSourceMonitor _dataSourceMonitor() {
            return new DataSourceMonitor();
        }

        @Bean
        public ApplicationListener dataSourceMonitor() {
            return new ApplicationListener<ContextRefreshedEvent>(){

                public void onApplicationEvent(ContextRefreshedEvent applicationStartedEvent) {
                    ApplicationContext context = applicationStartedEvent.getApplicationContext();
                    DataSourceMonitor dataSourceMonitor = (DataSourceMonitor)context.getBean("_dataSourceMonitor", DataSourceMonitor.class);
                    dataSourceMonitor.startMonitorThread(context);
                }
            };
        }

        private static class DataSourceMonitor
        implements DisposableBean {
            private boolean initted = false;
            private Map<String, BasicDataSource> dataSourceMap;
            private Map<String, PerfTestRoutingDataSource> routingdataSourceMap;
            private Thread dataSourceMonitorThread;

            private DataSourceMonitor() {
            }

            public synchronized void startMonitorThread(ApplicationContext context) {
                if (!this.initted) {
                    this.initted = true;
                    this.dataSourceMap = context.getBeansOfType(BasicDataSource.class);
                    this.routingdataSourceMap = context.getBeansOfType(PerfTestRoutingDataSource.class);
                    if (this.dataSourceMap.isEmpty() && this.routingdataSourceMap.isEmpty()) {
                        return;
                    }
                    this.dataSourceMonitorThread = new Thread(){

                        @Override
                        public void run() {
                            do {
                                for (Map.Entry entry : dataSourceMap.entrySet()) {
                                    this.scanDataSource((String)entry.getKey(), (BasicDataSource)entry.getValue());
                                }
                                for (Map.Entry entry : routingdataSourceMap.entrySet()) {
                                    this.scanDataSource((String)entry.getKey() + "_original", ((PerfTestRoutingDataSource)((Object)entry.getValue())).getOriginalDataSource());
                                    this.scanDataSource((String)entry.getKey() + "_shade", ((PerfTestRoutingDataSource)((Object)entry.getValue())).getShadeDataSource());
                                }
                                try {
                                    Thread.sleep(10000L);
                                }
                                catch (InterruptedException e) {
                                    break;
                                }
                            } while (!Thread.currentThread().isInterrupted());
                        }
                    };
                    this.dataSourceMonitorThread.start();
                }
            }

            private void scanDataSource(String key, BasicDataSource ds) {
                if (ds != null && !ds.isClosed()) {
                    int numIdleConnections = ds.getNumIdle();
                    int numBusyConnections = ds.getNumActive();
                    int numConnections = numBusyConnections + numIdleConnections;
                    int max = ds.getMaxTotal();
                    if (numBusyConnections >= 3 && numConnections >= max - 3 && numBusyConnections >= numConnections - 3) {
                        logger.error("datasource [" + key + "]'s connectionPool is too full,max:" + max + ",busy:" + numBusyConnections + ",idle:" + numIdleConnections);
                    }
                }
            }

            public synchronized void destroy() throws Exception {
                if (this.dataSourceMonitorThread != null) {
                    this.dataSourceMonitorThread.interrupt();
                }
            }
        }
    }
}

