/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.perftest;

import cn.com.duibaboot.ext.autoconfigure.perftest.JedisMethodInterceptor;
import cn.com.duibaboot.ext.autoconfigure.perftest.PerfTestContext;
import com.alibaba.ttl.TransmittableThreadLocal;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.connection.jedis.JedisConnection;
import org.springframework.data.redis.connection.jedis.JedisConnectionFactory;

@Aspect
public class JedisPerfAspect {
    private static final List<String> notInterceptorConectionMethodList = ImmutableList.builder().add((Object)"get").add((Object)"hGet").add((Object)"hGetAll").add((Object)"hMGet").add((Object)"mGet").add((Object)"hLen").add((Object)"lLen").add((Object)"strLen").add((Object)"bitCount").add((Object)"zCount").add((Object)"scan").add((Object)"hScan").add((Object)"sScan").add((Object)"zScan").add((Object)"keys").add((Object)"hKeys").build().asList();
    private static final Logger logger = LoggerFactory.getLogger(JedisPerfAspect.class);
    public static ConcurrentHashMap<String, JedisConnectionFactory> shadeDataSource = new ConcurrentHashMap();
    private final TransmittableThreadLocal<RedisConnection> shadeConnection = new TransmittableThreadLocal();
    private volatile Class<?> lastJedisConnectionProxyClass;

    @Around(value="execution(* org.springframework.data.redis.connection.jedis.JedisConnectionFactory.getConnection(..))")
    public Object springDataConnectionJoinPoint(ProceedingJoinPoint joinPoint) throws Throwable {
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        String methodName = signature.getMethod().getName();
        if ("getConnection".equals(methodName)) {
            JedisConnectionFactory jedisConnectionFactory = (JedisConnectionFactory)joinPoint.getTarget();
            JedisConnection connection = (JedisConnection)joinPoint.proceed();
            ProxyFactory factory = new ProxyFactory();
            factory.addAdvice((Advice)new JedisConnectionMethodInterceptor());
            factory.setTarget((Object)connection);
            JedisConnection newConnection = (JedisConnection)factory.getProxy();
            if (this.lastJedisConnectionProxyClass != null && this.lastJedisConnectionProxyClass != newConnection.getClass()) {
                logger.error("JedisConnectionProxyClass is not same\uff0cthis is spring's bug,please upgrade spring-boot's version to 1.3.8.RELEASE or higher! {},{},{},{}", new Object[]{this.getClass().getClassLoader(), newConnection.getClass().getClassLoader(), this.lastJedisConnectionProxyClass, newConnection.getClass()});
            }
            this.lastJedisConnectionProxyClass = newConnection.getClass();
            if (PerfTestContext.isCurrentInPerfTestMode()) {
                String dbKey = jedisConnectionFactory.getHostName() + jedisConnectionFactory.getPort();
                if (!shadeDataSource.contains(dbKey)) {
                    JedisConnectionFactory shadeConnectionFactory = new JedisConnectionFactory();
                    BeanUtils.copyProperties((Object)jedisConnectionFactory, (Object)shadeConnectionFactory);
                    shadeConnectionFactory.afterPropertiesSet();
                    shadeConnectionFactory.setDatabase(JedisMethodInterceptor.PERFDB_INDEX.intValue());
                    shadeDataSource.put(dbKey, shadeConnectionFactory);
                }
                this.shadeConnection.set((Object)shadeDataSource.get(dbKey).getConnection());
            }
            return newConnection;
        }
        return joinPoint.proceed();
    }

    private Object interceptorRedisConnectionMethods(MethodInvocation invocation) throws Throwable {
        String methodName = invocation.getMethod().getName();
        if (methodName.equals("toString") || methodName.equals("hashCode") || methodName.equals("equals")) {
            return invocation.proceed();
        }
        Object value = null;
        value = PerfTestContext.isCurrentInPerfTestMode() && !notInterceptorConectionMethodList.contains(methodName) ? invocation.getMethod().invoke(this.shadeConnection.get(), invocation.getArguments()) : invocation.proceed();
        return value;
    }

    private class JedisConnectionMethodInterceptor
    implements MethodInterceptor {
        JedisConnectionMethodInterceptor() {
        }

        public Object invoke(MethodInvocation invocation) throws Throwable {
            String methodName = invocation.getMethod().getName();
            if (methodName.equals("isPipelined") || methodName.equals("openPipeline") || methodName.equals("isQueueing") || methodName.equals("isClosed") || methodName.equals("close") || methodName.equals("closePipeline")) {
                return invocation.proceed();
            }
            if (methodName.equals("getNativeConnection")) {
                Object nativeConnection = invocation.proceed();
                ProxyFactory factory = new ProxyFactory();
                factory.addAdvice((Advice)new JedisMethodInterceptor());
                factory.setTarget(nativeConnection);
                Object newNativeConnection = factory.getProxy();
                return newNativeConnection;
            }
            return JedisPerfAspect.this.interceptorRedisConnectionMethods(invocation);
        }
    }
}

