/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.perftest;

import cn.com.duibaboot.ext.autoconfigure.perftest.JedisMethodInterceptor;
import cn.com.duibaboot.ext.autoconfigure.perftest.PerfTestAutoConfiguration;
import com.alibaba.ttl.TransmittableThreadLocal;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.aopalliance.aop.Advice;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.data.redis.connection.jedis.JedisConnectionFactory;
import redis.clients.jedis.Jedis;

@Aspect
public class RedisClientPerfAspect {
    private static final List<String> notInterceptorMethodList = ImmutableList.builder().add((Object)"get").add((Object)"hGet").add((Object)"hGetAll").add((Object)"hMGet").add((Object)"mGet").add((Object)"hLen").add((Object)"lLen").add((Object)"strLen").add((Object)"bitCount").add((Object)"zCount").add((Object)"scan").add((Object)"hScan").add((Object)"sScan").add((Object)"zScan").add((Object)"keys").add((Object)"hKeys").build().asList();
    private static final Logger logger = LoggerFactory.getLogger(RedisClientPerfAspect.class);
    public static ConcurrentHashMap<String, JedisConnectionFactory> shadeDataSource = new ConcurrentHashMap();
    private final TransmittableThreadLocal<Boolean> isPerf = new TransmittableThreadLocal();
    private volatile Class<?> lastJedisConnectionProxyClass;

    @Around(value="execution(* cn.com.duiba.wolf.redis.RedisClient.getResource(..))")
    public Object redisClientJoinPoint(ProceedingJoinPoint joinPoint) throws Throwable {
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        String methodName = signature.getMethod().getName();
        if ("getResource".equals(methodName)) {
            Jedis jedis = (Jedis)joinPoint.proceed();
            ProxyFactory factory = new ProxyFactory();
            factory.addAdvice((Advice)new JedisMethodInterceptor());
            factory.setTarget((Object)jedis);
            Jedis newConnection = (Jedis)factory.getProxy();
            if (this.lastJedisConnectionProxyClass != null && this.lastJedisConnectionProxyClass != newConnection.getClass()) {
                logger.error("JedisConnectionProxyClass is not same\uff0cthis is spring's bug,please upgrade spring-boot's version to 1.3.8.RELEASE or higher! {},{},{},{}", new Object[]{this.getClass().getClassLoader(), newConnection.getClass().getClassLoader(), this.lastJedisConnectionProxyClass, newConnection.getClass()});
            }
            this.lastJedisConnectionProxyClass = newConnection.getClass();
            if (PerfTestAutoConfiguration.TransmittableThreadLocalHolder.threadLocal2PressureTest.get() != null && ((Boolean)PerfTestAutoConfiguration.TransmittableThreadLocalHolder.threadLocal2PressureTest.get()).booleanValue()) {
                this.isPerf.set((Object)true);
            }
            return newConnection;
        }
        return joinPoint.proceed();
    }
}

