/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.cloud.netflix.ribbon;

import cn.com.duiba.wolf.threadpool.NamedThreadFactory;
import cn.com.duiba.wolf.utils.ConcurrentUtils;
import cn.com.duiba.wolf.utils.NumberUtils;
import cn.com.duibaboot.ext.autoconfigure.cloud.netflix.ribbon.CustomRibbonServerList;
import cn.com.duibaboot.ext.autoconfigure.cloud.netflix.ribbon.RibbonPing;
import cn.com.duibaboot.ext.autoconfigure.perftest.PerfTestContext;
import com.netflix.client.IClientConfigAware;
import com.netflix.client.config.IClientConfig;
import com.netflix.loadbalancer.ILoadBalancer;
import com.netflix.loadbalancer.IPing;
import com.netflix.loadbalancer.IPingStrategy;
import com.netflix.loadbalancer.IRule;
import com.netflix.loadbalancer.Server;
import com.netflix.loadbalancer.ServerList;
import com.netflix.loadbalancer.ZoneAvoidanceRule;
import com.netflix.niws.loadbalancer.DiscoveryEnabledServer;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.context.embedded.EmbeddedWebApplicationContext;
import org.springframework.cloud.netflix.feign.CustomFeignClientsRegistrar;
import org.springframework.cloud.netflix.ribbon.PropertiesFactory;
import org.springframework.cloud.netflix.ribbon.RibbonAutoConfiguration;
import org.springframework.cloud.netflix.ribbon.SpringClientFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

@Configuration
@ConditionalOnClass(value={IPing.class, IRule.class, ILoadBalancer.class, IPingStrategy.class})
public class RibbonCustomAutoConfiguration {
    @Resource
    private SpringClientFactory springClientFactory;

    @Bean
    public ApplicationListener SpringClientFactoryInitListener() {
        return new ApplicationListener<ContextRefreshedEvent>(){

            public void onApplicationEvent(ContextRefreshedEvent event) {
                if (event.getApplicationContext() instanceof EmbeddedWebApplicationContext) {
                    Set<String> enabledFeignClientNames = CustomFeignClientsRegistrar.getEnabledFeignClientNames();
                    for (String name : enabledFeignClientNames) {
                        RibbonCustomAutoConfiguration.this.springClientFactory.getClientConfig(name);
                    }
                }
            }
        };
    }

    @Bean
    public IPingStrategy getConcurrentRibbonPingStrategy() {
        return new ConcurrentPingStrategy();
    }

    @Bean
    public ApplicationListener ILoadBalancerInitListener() {
        return new ApplicationListener<ContextRefreshedEvent>(){

            public void onApplicationEvent(ContextRefreshedEvent event) {
                try {
                    ILoadBalancer bean = (ILoadBalancer)event.getApplicationContext().getBean(ILoadBalancer.class);
                    Field pingStrategyField = ReflectionUtils.findField(bean.getClass(), (String)"pingStrategy");
                    pingStrategyField.setAccessible(true);
                    if (pingStrategyField != null) {
                        ReflectionUtils.setField((Field)pingStrategyField, (Object)bean, (Object)RibbonCustomAutoConfiguration.this.getConcurrentRibbonPingStrategy());
                    }
                }
                catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
                    // empty catch block
                }
            }
        };
    }

    public static class CustomZoneAvoidanceRule
    extends ZoneAvoidanceRule {
        private final AtomicInteger nextIndex = new AtomicInteger();

        public Server choose(Object key) {
            DiscoveryEnabledServer server;
            String isPerfTestSupportted;
            ILoadBalancer lb = this.getLoadBalancer();
            List eligible = this.getPredicate().getEligibleServers(lb.getReachableServers(), key);
            Server choosedServer = !eligible.isEmpty() ? this.chooseRoundRobinWithTimeBasedWeight(eligible) : super.choose(key);
            if (choosedServer != null && choosedServer instanceof DiscoveryEnabledServer && !"1".equals(isPerfTestSupportted = (String)(server = (DiscoveryEnabledServer)choosedServer).getInstanceInfo().getMetadata().get("isPerfTestSupportted")) && PerfTestContext.isCurrentInPerfTestMode()) {
                throw new IllegalStateException("\u8bc6\u522b\u5230\u5f53\u524d\u8bf7\u6c42\u662f\u538b\u6d4b\u6d41\u91cf\uff0c\u4f46\u662f\u8c03\u7528\u7684\u670d\u52a1\u4e0d\u652f\u6301\u6027\u80fd\u538b\u6d4b\uff0c\u653e\u5f03\u672c\u6b21\u8bf7\u6c42\uff0c\u8bf7\u901a\u77e5\u8be5\u670d\u52a1\u8d1f\u8d23\u4eba\u52a0\u5165spring-boot-starter-perftest\u4f9d\u8d56\uff1b\u5c1d\u8bd5\u8c03\u7528\u7684\u670d\u52a1\u7aef\uff1a" + server.getInstanceInfo().getVIPAddress() + ",ip:" + server.getInstanceInfo().getIPAddr() + ",port:" + server.getInstanceInfo().getPort());
            }
            return choosedServer;
        }

        private Server chooseRoundRobinWithTimeBasedWeight(List<Server> eligible) {
            int length = eligible.size();
            int totalWeight = 0;
            boolean sameWeight = true;
            int[] weights = new int[length];
            for (int i = 0; i < length; ++i) {
                int weight;
                weights[i] = weight = this.getTimeBasedWeight(eligible.get(i));
                totalWeight += weight;
                if (!sameWeight || i <= 0 || weight == weights[i - 1]) continue;
                sameWeight = false;
            }
            if (totalWeight > 0 && !sameWeight) {
                int offset = this.nextIndex.getAndIncrement() % totalWeight;
                for (int i = 0; i < length; ++i) {
                    if ((offset -= weights[i]) >= 0) continue;
                    return eligible.get(i);
                }
            }
            return eligible.get(this.nextIndex.getAndIncrement() % eligible.size());
        }

        private int getTimeBasedWeight(Server server) {
            int weight = 100;
            if (server instanceof DiscoveryEnabledServer) {
                String weightStr = (String)((DiscoveryEnabledServer)server).getInstanceInfo().getMetadata().get("weight");
                weight = NumberUtils.parseInt((String)weightStr, (int)100);
                weight = Math.max(weight, 0);
            }
            if (weight > 0) {
                long timestamp = 0L;
                if (server instanceof DiscoveryEnabledServer) {
                    String tsStr = (String)((DiscoveryEnabledServer)server).getInstanceInfo().getMetadata().get("serverStartUpTime");
                    timestamp = NumberUtils.parseLong((String)tsStr, (long)0L);
                    timestamp = Math.max(timestamp, 0L);
                }
                if (timestamp > 0L) {
                    int uptime = (int)(System.currentTimeMillis() - timestamp);
                    int warmup = 300000;
                    if (uptime > 0 && uptime < warmup) {
                        weight = this.calculateWarmupWeight(uptime, warmup, weight);
                    }
                }
            }
            return weight;
        }

        private int calculateWarmupWeight(int uptime, int warmup, int weight) {
            int ww = (int)((float)uptime / ((float)warmup / (float)weight));
            if (ww < 1) {
                return 1;
            }
            return ww > weight ? weight : ww;
        }
    }

    private static class ConcurrentPingStrategy
    implements IPingStrategy,
    DisposableBean {
        private static final ExecutorService executor = Executors.newFixedThreadPool(20, (ThreadFactory)new NamedThreadFactory("ribbonPing"));
        private static final Logger logger = LoggerFactory.getLogger(ConcurrentPingStrategy.class);

        private ConcurrentPingStrategy() {
        }

        public boolean[] pingServers(final IPing ping, Server[] servers) {
            int numCandidates = servers.length;
            boolean[] results = new boolean[numCandidates];
            if (logger.isDebugEnabled()) {
                logger.debug("LoadBalancer:  PingTask executing [" + numCandidates + "] servers configured");
            }
            if (ping == null) {
                logger.error("IPing is null, will mark all servers as not alive");
                return results;
            }
            ArrayList<1> callables = new ArrayList<1>();
            for (final Server server : servers) {
                callables.add(new Callable<Boolean>(){

                    @Override
                    public Boolean call() throws Exception {
                        return ping.isAlive(server);
                    }
                });
            }
            if (executor.isTerminated()) {
                logger.error("IPing's executor is terminated(most likely your ApplicationContext is destroyed), will mark all servers as not alive");
                return results;
            }
            try {
                List ret = ConcurrentUtils.submitTasksBlocking((Executor)executor, callables);
                int i = 0;
                for (Boolean b : ret) {
                    results[i++] = b;
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return results;
        }

        public void destroy() throws Exception {
            executor.shutdown();
        }
    }

    @Configuration
    @AutoConfigureBefore(value={RibbonAutoConfiguration.class})
    @ConditionalOnClass(value={IPing.class, IRule.class, ILoadBalancer.class, IPingStrategy.class})
    public static class RibbonPropertiesFactoryConfiguration {
        @Bean
        public PropertiesFactory propertiesFactory(final ApplicationContext context) {
            return new PropertiesFactory(){

                public String getClassName(Class clazz, String name) {
                    if (clazz.equals(IRule.class)) {
                        return CustomZoneAvoidanceRule.class.getName();
                    }
                    if (clazz.equals(IPing.class)) {
                        return RibbonPing.class.getName();
                    }
                    if (clazz.equals(ServerList.class)) {
                        return CustomRibbonServerList.class.getName();
                    }
                    return super.getClassName(clazz, name);
                }

                public <C> C get(Class<C> clazz, IClientConfig config, String name) {
                    if (!ServerList.class.equals(clazz)) {
                        return (C)super.get(clazz, config, name);
                    }
                    String className = this.getClassName(clazz, name);
                    if (StringUtils.hasText((String)className)) {
                        try {
                            Class<?> toInstantiate = Class.forName(className);
                            return (C)this.instantiateWithConfig(context, toInstantiate, config);
                        }
                        catch (ClassNotFoundException e) {
                            throw new IllegalArgumentException("Unknown class to load " + className + " for class " + clazz + " named " + name);
                        }
                    }
                    return null;
                }

                <C> C instantiateWithConfig(ApplicationContext context2, Class<C> clazz, IClientConfig config) {
                    Object result = null;
                    try {
                        Constructor<C> constructor = clazz.getConstructor(IClientConfig.class);
                        result = constructor.newInstance(config);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    if (result == null) {
                        result = BeanUtils.instantiate(clazz);
                        if (result instanceof IClientConfigAware) {
                            ((IClientConfigAware)result).initWithNiwsConfig(config);
                        }
                        if (context2 != null) {
                            context2.getAutowireCapableBeanFactory().autowireBean(result);
                        }
                    }
                    return (C)result;
                }
            };
        }
    }
}

