/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.perftest;

import cn.com.duibaboot.ext.autoconfigure.perftest.PerfTestContext;
import com.mongodb.MongoClientURI;
import java.util.concurrent.ConcurrentHashMap;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.data.mongodb.MongoDbFactory;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.SimpleMongoDbFactory;

@Aspect
public class SpringDataMongodbPerfAspect {
    public static ConcurrentHashMap<String, String> OriginDataBaseUri = new ConcurrentHashMap();
    private ConcurrentHashMap<String, MongoTemplate> mongoTemplateConcurrentHashMap = new ConcurrentHashMap();

    @Around(value="execution(* org.springframework.data.mongodb.core.MongoTemplate.*(..))")
    public Object springDataMongodbJoinPoint(ProceedingJoinPoint joinPoint) throws Throwable {
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        MongoTemplate origin = (MongoTemplate)joinPoint.getTarget();
        String methodName = signature.getMethod().getName();
        Object[] args = joinPoint.getArgs();
        String dbName = origin.getDb().getName();
        if (PerfTestContext.isCurrentInPerfTestMode()) {
            if (!this.mongoTemplateConcurrentHashMap.containsKey(dbName)) {
                MongoClientURI mongoClientURI = new MongoClientURI(OriginDataBaseUri.get(dbName));
                String originDataBaseName = mongoClientURI.getDatabase();
                SimpleMongoDbFactory shadeFactory = new SimpleMongoDbFactory(new MongoClientURI(OriginDataBaseUri.replace("/" + originDataBaseName + "?", "/" + originDataBaseName + "_perf?")));
                this.mongoTemplateConcurrentHashMap.put(dbName, new MongoTemplate((MongoDbFactory)shadeFactory));
            }
            return signature.getMethod().invoke((Object)this.mongoTemplateConcurrentHashMap.get(dbName), args);
        }
        return joinPoint.proceed(args);
    }
}

