/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.plugin;

import cn.com.duibaboot.ext.autoconfigure.plugin.PluginException;
import cn.com.duibaboot.ext.autoconfigure.plugin.WitnessClassFinder;
import cn.com.duibaboot.ext.autoconfigure.plugin.match.ClassMatch;
import cn.com.duibaboot.ext.autoconfigure.plugin.util.StringUtil;
import net.bytebuddy.dynamic.DynamicType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractClassEnhancePluginDefine {
    private static final Logger logger = LoggerFactory.getLogger(AbstractClassEnhancePluginDefine.class);

    public DynamicType.Builder<?> define(String transformClassName, DynamicType.Builder<?> builder, ClassLoader classLoader) throws PluginException {
        String interceptorDefineClassName = this.getClass().getName();
        if (StringUtil.isEmpty(transformClassName)) {
            logger.warn("classname of being intercepted is not defined by {}.", (Object)interceptorDefineClassName);
            return null;
        }
        logger.debug("prepare to enhance class {} by {}.", (Object)transformClassName, (Object)interceptorDefineClassName);
        String[] witnessClasses = this.witnessClasses();
        if (witnessClasses != null) {
            for (String witnessClass : witnessClasses) {
                if (WitnessClassFinder.INSTANCE.exist(witnessClass, classLoader)) continue;
                logger.warn("enhance class {} by plugin {} is not working. Because witness class {} is not existed.", new Object[]{transformClassName, interceptorDefineClassName, witnessClass});
                return null;
            }
        }
        DynamicType.Builder<?> newClassBuilder = this.enhance(transformClassName, builder, classLoader);
        logger.debug("enhance class {} by {} completely.", (Object)transformClassName, (Object)interceptorDefineClassName);
        return newClassBuilder;
    }

    protected abstract DynamicType.Builder<?> enhance(String var1, DynamicType.Builder<?> var2, ClassLoader var3) throws PluginException;

    protected abstract ClassMatch enhanceClass();

    protected String[] witnessClasses() {
        return new String[0];
    }
}

