/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.plugin.interceptor.enhance;

import cn.com.duibaboot.ext.autoconfigure.plugin.PluginException;
import cn.com.duibaboot.ext.autoconfigure.plugin.interceptor.enhance.EnhancedInstance;
import cn.com.duibaboot.ext.autoconfigure.plugin.interceptor.enhance.InstanceMethodsAroundInterceptor;
import cn.com.duibaboot.ext.autoconfigure.plugin.interceptor.enhance.MethodInterceptResult;
import cn.com.duibaboot.ext.autoconfigure.plugin.interceptor.loader.InterceptorInstanceLoader;
import java.lang.reflect.Method;
import java.util.concurrent.Callable;
import net.bytebuddy.implementation.bind.annotation.AllArguments;
import net.bytebuddy.implementation.bind.annotation.Origin;
import net.bytebuddy.implementation.bind.annotation.RuntimeType;
import net.bytebuddy.implementation.bind.annotation.SuperCall;
import net.bytebuddy.implementation.bind.annotation.This;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstMethodsInter {
    private static final Logger logger = LoggerFactory.getLogger(InstMethodsInter.class);
    private InstanceMethodsAroundInterceptor interceptor;

    public InstMethodsInter(String instanceMethodsAroundInterceptorClassName, ClassLoader classLoader) {
        try {
            this.interceptor = (InstanceMethodsAroundInterceptor)InterceptorInstanceLoader.load(instanceMethodsAroundInterceptorClassName, classLoader);
        }
        catch (Throwable t) {
            throw new PluginException("Can't create InstanceMethodsAroundInterceptor.", t);
        }
    }

    @RuntimeType
    public Object intercept(@This Object obj, @AllArguments Object[] allArguments, @SuperCall Callable<?> zuper, @Origin Method method) throws Throwable {
        EnhancedInstance targetObject = (EnhancedInstance)obj;
        MethodInterceptResult result = new MethodInterceptResult();
        this.interceptor.beforeMethod(targetObject, method, allArguments, method.getParameterTypes(), result);
        Object ret = null;
        try {
            ret = !result.isContinue() ? result._ret() : zuper.call();
        }
        catch (Throwable t) {
            try {
                this.interceptor.handleMethodException(targetObject, method, allArguments, method.getParameterTypes(), t);
            }
            catch (Throwable t2) {
                logger.error("class[{}] handle method[{}] exception failure", obj.getClass(), (Object)method.getName());
            }
            throw t;
        }
        finally {
            try {
                ret = this.interceptor.afterMethod(targetObject, method, allArguments, method.getParameterTypes(), ret);
            }
            catch (Throwable t) {
                logger.error("class[{}] after method[{}] intercept failure", obj.getClass(), (Object)method.getName());
            }
        }
        return ret;
    }
}

