/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.plugin.interceptor.enhance;

import cn.com.duibaboot.ext.autoconfigure.plugin.interceptor.enhance.MethodInterceptResult;
import cn.com.duibaboot.ext.autoconfigure.plugin.interceptor.enhance.OverrideCallable;
import cn.com.duibaboot.ext.autoconfigure.plugin.interceptor.enhance.StaticMethodsAroundInterceptor;
import cn.com.duibaboot.ext.autoconfigure.plugin.interceptor.loader.InterceptorInstanceLoader;
import java.lang.reflect.Method;
import net.bytebuddy.implementation.bind.annotation.AllArguments;
import net.bytebuddy.implementation.bind.annotation.Morph;
import net.bytebuddy.implementation.bind.annotation.Origin;
import net.bytebuddy.implementation.bind.annotation.RuntimeType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StaticMethodsInterWithOverrideArgs {
    private static final Logger logger = LoggerFactory.getLogger(StaticMethodsInterWithOverrideArgs.class);
    private String staticMethodsAroundInterceptorClassName;

    public StaticMethodsInterWithOverrideArgs(String staticMethodsAroundInterceptorClassName) {
        this.staticMethodsAroundInterceptorClassName = staticMethodsAroundInterceptorClassName;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @RuntimeType
    public Object intercept(@Origin Class<?> clazz, @AllArguments Object[] allArguments, @Origin Method method, @Morph OverrideCallable zuper) throws Throwable {
        StaticMethodsAroundInterceptor interceptor = (StaticMethodsAroundInterceptor)InterceptorInstanceLoader.load(this.staticMethodsAroundInterceptorClassName, clazz.getClassLoader());
        MethodInterceptResult result = new MethodInterceptResult();
        try {
            interceptor.beforeMethod(clazz, method, allArguments, method.getParameterTypes(), result);
        }
        catch (Throwable t) {
            logger.error("class[{}] before static method[{}] intercept failure", clazz, (Object)method.getName());
        }
        Object ret = null;
        try {
            ret = !result.isContinue() ? result._ret() : zuper.call(allArguments);
        }
        catch (Throwable t) {
            try {
                try {
                    interceptor.handleMethodException(clazz, method, allArguments, method.getParameterTypes(), t);
                    throw t;
                }
                catch (Throwable t2) {
                    logger.error("class[{}] handle static method[{}] exception failure", new Object[]{clazz, method.getName(), t2.getMessage()});
                }
                throw t;
            }
            catch (Throwable throwable) {
                try {
                    ret = interceptor.afterMethod(clazz, method, allArguments, method.getParameterTypes(), ret);
                    throw throwable;
                }
                catch (Throwable t2) {
                    logger.error("class[{}] after static method[{}] intercept failure:{}", new Object[]{clazz, method.getName(), t2.getMessage()});
                }
                throw throwable;
            }
        }
        try {
            return interceptor.afterMethod(clazz, method, allArguments, method.getParameterTypes(), ret);
        }
        catch (Throwable t) {
            logger.error("class[{}] after static method[{}] intercept failure:{}", new Object[]{clazz, method.getName(), t.getMessage()});
            return ret;
        }
    }
}

