/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.plugin.match;

import cn.com.duibaboot.ext.autoconfigure.plugin.match.ClassMatch;
import cn.com.duibaboot.ext.autoconfigure.plugin.match.IndirectMatch;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.description.type.TypeList;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;

public class HierarchyMatch
implements IndirectMatch {
    private String[] parentTypes;

    private HierarchyMatch(String[] parentTypes) {
        if (parentTypes == null || parentTypes.length == 0) {
            throw new IllegalArgumentException("parentTypes is null");
        }
        this.parentTypes = parentTypes;
    }

    @Override
    public ElementMatcher.Junction buildJunction() {
        ElementMatcher.Junction junction = null;
        for (String superTypeName : this.parentTypes) {
            junction = junction == null ? this.buildSuperClassMatcher(superTypeName) : junction.and((ElementMatcher)this.buildSuperClassMatcher(superTypeName));
        }
        junction = junction.and((ElementMatcher)ElementMatchers.not((ElementMatcher)ElementMatchers.isInterface()));
        return junction;
    }

    private ElementMatcher.Junction buildSuperClassMatcher(String superTypeName) {
        return ElementMatchers.hasSuperType((ElementMatcher)ElementMatchers.named((String)superTypeName));
    }

    @Override
    public boolean isMatch(TypeDescription typeDescription) {
        ArrayList<String> parentTypes = new ArrayList<String>(Arrays.asList(this.parentTypes));
        TypeList.Generic implInterfaces = typeDescription.getInterfaces();
        for (TypeDescription.Generic implInterface : implInterfaces) {
            this.matchHierarchyClass(implInterface, parentTypes);
        }
        this.matchHierarchyClass(typeDescription.getSuperClass(), parentTypes);
        return parentTypes.size() == 0;
    }

    private void matchHierarchyClass(TypeDescription.Generic clazz, List<String> parentTypes) {
        parentTypes.remove(clazz.asErasure().getActualName());
        if (parentTypes.size() == 0) {
            return;
        }
        for (TypeDescription.Generic generic : clazz.getInterfaces()) {
            this.matchHierarchyClass(generic, parentTypes);
        }
        TypeDescription.Generic superClazz = clazz.getSuperClass();
        if (superClazz != null && !clazz.getTypeName().equals("java.lang.Object")) {
            this.matchHierarchyClass(superClazz, parentTypes);
        }
    }

    public static ClassMatch byHierarchyMatch(String[] parentTypes) {
        return new HierarchyMatch(parentTypes);
    }
}

