package cn.com.duibaboot.ext.autoconfigure.perftest;

import com.ea.agentloader.AgentLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.SpringApplicationRunListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;

/**
 * 自动配置优雅停机
 * <br/>
 *
 * 不能优雅停机的原因：各个框架包括spring、dubbo、xmemcached等在初始化时都添加了自己的shutdownhook，而且这些shutdownhook的执行是无序的，所以有可能在dubbo销毁前xmemcached、datasource等已经销毁，导致关闭期间的几秒内大量报错
 * <br/>
 *
 * 解决方法：在spring启动后通过反射移除所有shutdownhook，并添加必要的spring的shutdownhook、添加必要的dubbo清理代码，实现优雅停机
 *
 * Created by wenqi.huang on 2016/12/27.
 */
public class AttachAgentListener implements SpringApplicationRunListener {

    private static final Logger logger = LoggerFactory.getLogger(AttachAgentListener.class);

    private SpringApplication application;

    private static boolean startingCalled = false;

    /**
     * 必须有这个构造函数，否则spring无法初始化该类
     * @param application
     * @param args
     */
    public AttachAgentListener(SpringApplication application, String[] args) {
        this.application = application;
    }

    //@Override //boot新版本没有这个方法，故去掉Override
    public void started() {
        AgentLoader.loadAgentClass(PluginAgent.class.getName(), null);
    }

    // boot 1.5.2 新版本有这个方法，故要实现
    //@Override
    public void starting() {
        AgentLoader.loadAgentClass(PluginAgent.class.getName(), null);
    }

    //@Override
    public void environmentPrepared(ConfigurableEnvironment environment) {

    }

    //@Override
    public void contextPrepared(ConfigurableApplicationContext context) {

    }

    //@Override
    public void contextLoaded(ConfigurableApplicationContext context) {

    }

    @Override
    public void finished(final ConfigurableApplicationContext context, Throwable exception) {
    }

}
