package cn.com.duibaboot.ext.autoconfigure.perftest;

import com.alibaba.dubbo.common.extension.Activate;
import com.alibaba.dubbo.rpc.*;

/**
 * Created by wenqi.huang on 2016/11/24.
 */
@Activate(group={"consumer","provider"},order = 0)
public class DubboPerfTestFilter implements Filter {

    public static final String IS_PERF_TEST_MODE = "isPerfTestMode";

    @Override
    public Result invoke(Invoker<?> invoker, Invocation invocation) throws RpcException {
        RpcContext context = RpcContext.getContext();
        if(context.isConsumerSide()) {
            if (PerfTestContext.isCurrentInPerfTestMode()) {//表示线上压测流量
                boolean isPerfTestSupportted = invoker.getUrl().getParameter(DubboPerfTestRegistryFactoryWrapper.IS_PERF_TEST_SUPPORTTED_KEY, false);
                if(!isPerfTestSupportted){
                    throw new RpcException("dubbo invoker:"+invoker.getUrl().toServiceString()+"，识别到当前请求是压测流量，但是对应的服务不支持性能压测，放弃本次请求，请通知该服务负责人加入spring-boot-starter-perftest项目");
                }
                context.setAttachment(IS_PERF_TEST_MODE, "true");//这个标记在dubbo请求完毕后会自动清空
            }
        }else{
            String val = context.getAttachment(IS_PERF_TEST_MODE);
            if("true".equals(val)){
                PerfTestAutoConfiguration.TransmittableThreadLocalHolder.threadLocal2PressureTest.set(true);
            }
        }

        Result result = null;
        try {
            result = invoker.invoke(invocation);
        }finally {
            if(context.isProviderSide()) {
                PerfTestAutoConfiguration.TransmittableThreadLocalHolder.threadLocal2PressureTest.remove();
            }
        }
        return result;
    }
}
