package cn.com.duibaboot.ext.autoconfigure.perftest;

import java.util.List;

import cn.com.duibaboot.ext.autoconfigure.perftest.PerfTestAutoConfiguration;
import com.aliyun.openservices.ons.api.SendResult;
import com.google.common.collect.Lists;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.redis.connection.jedis.JedisConnection;

/**
 * 加入AOP，压测时不发送ons消息
 */
@Aspect
public class OnsPerfAspect {


    private static final Logger logger = LoggerFactory.getLogger(OnsPerfAspect.class);


    @Around("execution(* com.aliyun.openservices.ons.api.Producer+.*(..))")
    public Object springDataRedisJoinPoint(ProceedingJoinPoint joinPoint) throws Throwable {
        MethodSignature signature = (MethodSignature) joinPoint.getSignature();
        String methodName = signature.getMethod().getName();
        if (PerfTestContext.isCurrentInPerfTestMode()) {
            if(methodName.equals("send"))return new SendResult();
            return null;
        }
        return joinPoint.proceed();
    }
}
