package cn.com.duibaboot.ext.autoconfigure.perftest;

import java.util.List;

import com.google.common.collect.Lists;
import org.apache.rocketmq.client.producer.SendResult;
import org.apache.rocketmq.client.producer.TransactionSendResult;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * 加入AOP，压测时不发送rocketmq消息
 */
@Aspect
public class RocketMqPerfAspect {

    private static final Logger logger = LoggerFactory.getLogger(RocketMqPerfAspect.class);

    @Around("execution(* org.apache.rocketmq.client.producer.DefaultMQProducer+.*(..))")
    public Object springDataRedisJoinPoint(ProceedingJoinPoint joinPoint) throws Throwable {
        MethodSignature signature = (MethodSignature) joinPoint.getSignature();
        String methodName = signature.getMethod().getName();
        if (PerfTestContext.isCurrentInPerfTestMode()) {
            if(signature.getReturnType().equals(SendResult.class))return new SendResult();
            if(signature.getReturnType().equals(TransactionSendResult.class))return new TransactionSendResult();
            return null;
        }
        return joinPoint.proceed();
    }
}
