package cn.com.duibaboot.ext.autoconfigure.perftest.guava;


import static cn.com.duibaboot.ext.autoconfigure.plugin.match.HierarchyMatch.byHierarchyMatch;
import static net.bytebuddy.matcher.ElementMatchers.named;


import cn.com.duibaboot.ext.autoconfigure.plugin.interceptor.ConstructorInterceptPoint;
import cn.com.duibaboot.ext.autoconfigure.plugin.interceptor.InstanceMethodsInterceptPoint;
import cn.com.duibaboot.ext.autoconfigure.plugin.interceptor.enhance.ClassInstanceMethodsEnhancePluginDefine;
import cn.com.duibaboot.ext.autoconfigure.plugin.match.ClassMatch;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.matcher.ElementMatcher;


public class GuavaCacheInstrumentation extends ClassInstanceMethodsEnhancePluginDefine {

    private static final String ENHANCE_CLASS = "com.google.common.cache.CacheLoader";
    private static final String INTERCEPT_CLASS = "cn.com.duibaboot.ext.autoconfigure.perftest.guava.GuavaCacheInterceptor";

    @Override
    protected ClassMatch enhanceClass() {
        String[] parentType=new String[]{ENHANCE_CLASS};
        return byHierarchyMatch(parentType);
    }

    @Override
    protected ConstructorInterceptPoint[] getConstructorsInterceptPoints() {
        return null;
    }

    @Override
    protected InstanceMethodsInterceptPoint[] getInstanceMethodsInterceptPoints() {
        return new InstanceMethodsInterceptPoint[] {
            new InstanceMethodsInterceptPoint() {
                @Override
                public ElementMatcher<MethodDescription> getMethodsMatcher() {
                    return named("load");
                }

                @Override
                public String getMethodsInterceptor() {
                    return INTERCEPT_CLASS;
                }

                @Override
                public boolean isOverrideArgs() {
                    return false;
                }
            }
        };
    }
}
