package cn.com.duibaboot.ext.autoconfigure.perftest.guava;

import java.lang.reflect.Method;

import cn.com.duibaboot.ext.autoconfigure.perftest.PerfTestContext;
import cn.com.duibaboot.ext.autoconfigure.plugin.interceptor.enhance.EnhancedInstance;
import cn.com.duibaboot.ext.autoconfigure.plugin.interceptor.enhance.InstanceMethodsAroundInterceptor;
import cn.com.duibaboot.ext.autoconfigure.plugin.interceptor.enhance.MethodInterceptResult;
import com.alibaba.ttl.TransmittableThreadLocal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;


public class GuavaCacheInterceptor implements InstanceMethodsAroundInterceptor {
    private final Logger logger=  LoggerFactory.getLogger(GuavaCacheInterceptor.class);
    private final TransmittableThreadLocal<Boolean> perfMode = new TransmittableThreadLocal<>();
    @Override
    public void beforeMethod(EnhancedInstance objInst, Method method, Object[] allArguments,
                             Class<?>[] argumentsTypes, MethodInterceptResult result) throws Throwable {
        boolean isPerf = PerfTestContext.isCurrentInPerfTestMode();
        if (isPerf) {
            PerfTestContext.setPerfTestMode(false);
            perfMode.set(isPerf);
        }
    }

    @Override
    public Object afterMethod(EnhancedInstance objInst, Method method, Object[] allArguments,
                              Class<?>[] argumentsTypes, Object ret) throws Throwable {
        if (perfMode.get() != null && perfMode.get()) {
            PerfTestContext.setPerfTestMode(perfMode.get());
        }
        return ret;
    }

    @Override
    public void handleMethodException(EnhancedInstance objInst, Method method, Object[] allArguments,
                                      Class<?>[] argumentsTypes, Throwable t) {
    }
}
