package cn.com.duibaboot.ext.autoconfigure.perftest.jedis;

import java.lang.reflect.Method;

import cn.com.duibaboot.ext.autoconfigure.perftest.PerfTestContext;
import cn.com.duibaboot.ext.autoconfigure.plugin.interceptor.enhance.EnhancedInstance;
import cn.com.duibaboot.ext.autoconfigure.plugin.interceptor.enhance.InstanceMethodsAroundInterceptor;
import cn.com.duibaboot.ext.autoconfigure.plugin.interceptor.enhance.MethodInterceptResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Jedis;


public class JedisMethodInterceptor implements InstanceMethodsAroundInterceptor {
    private final Logger logger = LoggerFactory.getLogger(JedisMethodInterceptor.class);
    private static final Integer PERF_INDEX=2;
    @Override
    public void beforeMethod(EnhancedInstance objInst, Method method, Object[] allArguments,
                             Class<?>[] argumentsTypes, MethodInterceptResult result) throws Throwable {
        if (PerfTestContext.isCurrentInPerfTestMode()) {
            ((Jedis) objInst).select(PERF_INDEX);
        }
    }

    @Override
    public Object afterMethod(EnhancedInstance objInst, Method method, Object[] allArguments,
                              Class<?>[] argumentsTypes, Object ret) throws Throwable {
        if (PerfTestContext.isCurrentInPerfTestMode()) {
            ((Jedis) objInst).select(0);
        }
        return ret;
    }

    @Override
    public void handleMethodException(EnhancedInstance objInst, Method method, Object[] allArguments,
                                      Class<?>[] argumentsTypes, Throwable t) {

    }
}
