package cn.com.duibaboot.ext.autoconfigure.javaagent;

import com.ea.agentloader.AgentLoader;
import com.ea.agentloader.ClassPathUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.SpringApplicationRunListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;

import java.io.*;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.jar.*;

/**
 * 应用启动后附加JavaAgent以修改类的字节码，进行一些aop处理
 */
public class AttachJavaAgentListener implements SpringApplicationRunListener {

    private static final Logger logger = LoggerFactory.getLogger(AttachJavaAgentListener.class);

    private SpringApplication application;

    private static boolean startingCalled = false;

    /**
     * 必须有这个构造函数，否则spring无法初始化该类
     * @param application
     * @param args
     */
    public AttachJavaAgentListener(SpringApplication application, String[] args) {
        this.application = application;
    }

    //@Override //boot新版本没有这个方法，故去掉Override
    public void started() {
        this.starting();
    }

    // boot 1.5.2 新版本有这个方法，故要实现
    //@Override
    public void starting() {
        Thread.currentThread().getThreadGroup();
        if(!startingCalled){
            startingCalled = true;
            String agentClass = "cn.com.duibaboot.ext.autoconfigure.javaagent.PluginAgentDelegate";
            String jarPath;
            try {
                jarPath = loadAgentClassesIntoSystemClassLoader(agentClass);
            } catch (IOException e) {
                throw new RuntimeException(e);
            }
            if(jarPath != null){
                AgentLoader.loadAgent(jarPath, null);
            }else {
                AgentLoader.loadAgentClass(agentClass, null);
            }
        }
    }

    private String loadAgentClassesIntoSystemClassLoader(String agentClass) throws IOException {
        if(AttachJavaAgentListener.class.getClassLoader() != ClassLoader.getSystemClassLoader()) {
            //当前类不是AppClassLoader加载的，表示在spring的jar inside jar模式下运行，这里做特殊处理，把javaagent相关类导出到独立的jar包中，并添加进AppClassLoader的加载路径中。

            //ClassPathUtils.appendToSystemPath(ClassPathUtils.getClassPathFor(PluginAgent.class));

//            ClassPathUtils.appendToSystemPath(writeJar("jar:file:/Users/wenqi.huang/Documents/workspace-idea/springBootWebDemo/build/libs/springBootWebDemo-0.0.1-SNAPSHOT.jar!/BOOT-INF/lib/spring-boot-ext-javaagent-1.2.42.h6.jar!/"));
            ClassPathUtils.appendToSystemPath(writeJar("jar:file:/Users/wenqi.huang/Documents/workspace-idea/springBootWebDemo/build/libs/springBootWebDemo-0.0.1-SNAPSHOT.jar!/BOOT-INF/lib/byte-buddy-1.7.1.jar!/"));
            ClassPathUtils.appendToSystemPath(writeJar("jar:file:/Users/wenqi.huang/Documents/workspace-idea/springBootWebDemo/build/libs/springBootWebDemo-0.0.1-SNAPSHOT.jar!/BOOT-INF/lib/byte-buddy-agent-1.5.7.jar!/"));
//            ClassPathUtils.appendToSystemPath(writeJar("jar:file:/Users/wenqi.huang/Documents/workspace-idea/springBootWebDemo/build/libs/springBootWebDemo-0.0.1-SNAPSHOT.jar!/BOOT-INF/lib/slf4j-api-1.7.25.jar!/"));


            final File jarFile = File.createTempFile("spring/javaagent." + agentClass, ".jar");
            jarFile.deleteOnExit();
            createAgentJar(new FileOutputStream(jarFile),
                    agentClass,
                    null,
                    true,
                    true,
                    false);

            return jarFile.toString();
        }

        return null;
    }

    private void createAgentJar(
            final OutputStream out,
            final String agentClass,
            final String bootClassPath,
            final boolean canRedefineClasses,
            final boolean canRetransformClasses,
            final boolean canSetNativeMethodPrefix) throws IOException {
        final Manifest man = new Manifest();
        man.getMainAttributes().put(Attributes.Name.MANIFEST_VERSION, "1.0");
        man.getMainAttributes().putValue("Agent-Class", agentClass);
        if (bootClassPath != null)
        {
            man.getMainAttributes().putValue("Boot-Class-Path", bootClassPath);
        }
        man.getMainAttributes().putValue("Can-Redefine-Classes", Boolean.toString(canRedefineClasses));
        man.getMainAttributes().putValue("Can-Retransform-Classes", Boolean.toString(canRetransformClasses));
        man.getMainAttributes().putValue("Can-Set-Native-Method-Prefix", Boolean.toString(canSetNativeMethodPrefix));
        final JarOutputStream jarOut = new JarOutputStream(out, man);

        appendClassToJar("jar:file:/Users/wenqi.huang/Documents/workspace-idea/springBootWebDemo/build/libs/springBootWebDemo-0.0.1-SNAPSHOT.jar!/BOOT-INF/lib/spring-boot-ext-1.2.42.h10.jar!/", jarOut);

        jarOut.flush();
        jarOut.close();
    }

    private URL writeJar(String url) throws IOException{
        URLConnection connection = new URL(url).openConnection();
        File file = File.createTempFile("spring/spring-", ".jar");
        file.deleteOnExit();
        if (connection instanceof JarURLConnection) {
            JarFile jarFile = ((JarURLConnection) connection)
                    .getJarFile();

            final JarOutputStream jarOut =
                    new JarOutputStream(
                            new FileOutputStream(file));
            Enumeration<JarEntry> e = jarFile.entries();
            while (e.hasMoreElements()) {
                JarEntry jarEntry = e.nextElement();
                jarOut.putNextEntry(jarEntry);
                InputStream in = jarFile.getInputStream(jarEntry);
                byte[] bs = new byte[128];
                int n = -1;
                while ((n = in.read(bs)) != -1) {
                    jarOut.write(bs, 0, n);
                }
                jarOut.closeEntry();
            }
            jarOut.close();
        }

        URL url1 = file.toURI().toURL();
        System.out.println("write-complete:" + url1.toString());
        return url1;
    }

    private void appendClassToJar(String url, JarOutputStream jarOut) throws IOException{
        URLConnection connection = new URL(url).openConnection();
        if (connection instanceof JarURLConnection) {
            JarFile jarFile = ((JarURLConnection) connection)
                    .getJarFile();

            Enumeration<JarEntry> e = jarFile.entries();
            while (e.hasMoreElements()) {
                JarEntry jarEntry = e.nextElement();
                if(!jarEntry.toString().contains("PluginAgentDelegate")){
                    continue;
                }
                jarOut.putNextEntry(jarEntry);
                InputStream in = jarFile.getInputStream(jarEntry);
                byte[] bs = new byte[128];
                int n = -1;
                while ((n = in.read(bs)) != -1) {
                    jarOut.write(bs, 0, n);
                }
                jarOut.closeEntry();
            }
        }
    }

    //@Override
    public void environmentPrepared(ConfigurableEnvironment environment) {

    }

    //@Override
    public void contextPrepared(ConfigurableApplicationContext context) {

    }

    //@Override
    public void contextLoaded(ConfigurableApplicationContext context) {

    }

    @Override
    public void finished(final ConfigurableApplicationContext context, Throwable exception) {
    }


    public static void main(String[] args) {
        System.out.println(ClassLoader.getSystemClassLoader() instanceof URLClassLoader);
    }
}
