package cn.com.duibaboot.ext.autoconfigure.javaagent;

import java.lang.instrument.Instrumentation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class PluginAgentDelegate {

    public static void agentmain(String args, Instrumentation instrumentation) {
        ClassLoader springClassLoader = getClassLoaderOfMainThread();

        //TODO 下面这句去掉试试
        Thread.currentThread().setContextClassLoader(springClassLoader);

        try {
            Class<?> pluginAgentClass = springClassLoader.loadClass("cn.com.duiba.boot.ext.javaagent.main.PluginAgent");

            Method agentmain = pluginAgentClass.getDeclaredMethod("agentmain", String.class, Instrumentation.class);
            agentmain.invoke(null, args, instrumentation);

        } catch (ClassNotFoundException | NoSuchMethodException
                |IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException("[NOTIFYME]will not be here", e);
        }
    }

    /**
     * 获取主线程（名为main的ThreadGroup下的id为1的线程），并获得其ClassLoader
     * @return
     */
    private static ClassLoader getClassLoaderOfMainThread(){
        ThreadGroup systemGroup = Thread.currentThread().getThreadGroup();
        ThreadGroup[] childGroups = (ThreadGroup[])getFieldValue(systemGroup, "groups");
        if(childGroups == null || childGroups.length == 0){
            throw new IllegalStateException("[NOTIFYME]will not be here");
        }

        for(ThreadGroup tg : childGroups){
            if(tg != null && "main".equals(tg.getName())){
                Thread[] threads = (Thread[])getFieldValue(tg, "threads");
                for(Thread thread : threads){
                    if(thread != null && thread.getId() == 1){
                        //主线程
                        return thread.getContextClassLoader();
                    }
                }
            }
        }

        throw new IllegalStateException("[NOTIFYME]main thread not found, will not be here");
    }

    private static Object getFieldValue(Object obj, String fieldName){
        try {
            Field field = obj.getClass().getDeclaredField(fieldName);
            field.setAccessible(true);
            return field.get(obj);
        } catch (NoSuchFieldException | IllegalAccessException  e) {
            throw new RuntimeException(e);
        }
    }

}
