package cn.com.duibaboot.ext.autoconfigure.threadpool.wrapper;

import cn.com.duiba.wolf.perf.timeprofile.DBTimeProfile;
import cn.com.duiba.wolf.threadpool.MonitorCallable;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;

/**
 * 增加监控耗时的功能
 */
public class ProfileCallable extends MonitorCallable {

    public ProfileCallable(Callable callable) {
        super(callable);
    }

    public ProfileCallable(Callable callable, BlockingQueue<Runnable> queue) {
        super(callable, queue);
    }

    @Override
    public Object call() throws Exception {
        DBTimeProfile.start();
        try {
            return super.call();
        }finally{
            DBTimeProfile.end("unknown, thread:" + Thread.currentThread().getName());
        }
    }
}
