/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.perftest.jedis;

import cn.com.duiba.boot.ext.javaagent.plugin.interceptor.enhance.EnhancedInstance;
import cn.com.duiba.boot.ext.javaagent.plugin.interceptor.enhance.InstanceMethodsAroundInterceptor;
import cn.com.duiba.boot.ext.javaagent.plugin.interceptor.enhance.MethodInterceptResult;
import cn.com.duiba.boot.perftest.PerfTestContext;
import com.alibaba.ttl.TransmittableThreadLocal;
import com.google.common.base.MoreObjects;
import java.lang.reflect.Method;
import redis.clients.jedis.Jedis;

public class JedisMethodInterceptor
implements InstanceMethodsAroundInterceptor {
    private static final Integer PERF_INDEX = 1;
    private final TransmittableThreadLocal<Integer> perfMode = new TransmittableThreadLocal();

    public void beforeMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, MethodInterceptResult result) throws Throwable {
        if (PerfTestContext.isCurrentInPerfTestMode()) {
            Integer state = (Integer)MoreObjects.firstNonNull((Object)this.perfMode.get(), (Object)0);
            state = state + 1;
            this.perfMode.set((Object)state);
            if (state > 1) {
                return;
            }
            PerfTestContext.debugInfo((String)"Jedis");
            Jedis jedis = (Jedis)objInst;
            jedis.select(jedis.getDB().intValue() + PERF_INDEX);
        }
    }

    public Object afterMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Object ret) throws Throwable {
        if (PerfTestContext.isCurrentInPerfTestMode()) {
            Integer state = (Integer)this.perfMode.get();
            state = state - 1;
            this.perfMode.set((Object)state);
            if (state == 0) {
                Jedis jedis = (Jedis)objInst;
                jedis.select(jedis.getDB().intValue() - PERF_INDEX);
                this.perfMode.remove();
            }
        }
        return ret;
    }

    public void handleMethodException(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Throwable t) {
    }
}

