/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.cloud.netflix.eureka;

import cn.com.duibaboot.ext.autoconfigure.cloud.netflix.eureka.DiscoveryMetadataRegister;
import com.netflix.appinfo.ApplicationInfoManager;
import java.util.HashMap;
import java.util.List;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.SearchStrategy;
import org.springframework.cloud.context.scope.refresh.RefreshScopeRefreshedEvent;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.EventListener;
import org.springframework.core.annotation.Order;

@Configuration
@AutoConfigureAfter(name={"org.springframework.cloud.netflix.eureka.EurekaClientAutoConfiguration"})
@ConditionalOnBean(type={"com.netflix.appinfo.ApplicationInfoManager"}, search=SearchStrategy.CURRENT)
public class DiscoveryMetadataAutoConfiguration {
    private static long serverStartUpTime;
    public static final String SERVER_START_UP_TIME_KEY = "serverStartUpTime";
    public static final String WEIGHT_KEY = "weight";
    @Autowired
    private ApplicationInfoManager applicationInfoManager;
    @Autowired(required=false)
    private List<DiscoveryMetadataRegister> discoveryMetadataRegisters;

    private synchronized long getServerStartUpTime() {
        if (serverStartUpTime == 0L) {
            serverStartUpTime = System.currentTimeMillis();
        }
        return serverStartUpTime;
    }

    @EventListener(value={RefreshScopeRefreshedEvent.class})
    @Order(value=-2147483648)
    public void onRefresh(RefreshScopeRefreshedEvent event) {
        this.registerAppMetadataCommon();
    }

    @PostConstruct
    public void init() {
        this.registerAppMetadataCommon();
    }

    private void registerAppMetadataCommon() {
        long serverStartUpTime = this.getServerStartUpTime();
        if (this.applicationInfoManager != null) {
            HashMap<String, String> metadata = new HashMap<String, String>();
            metadata.put(SERVER_START_UP_TIME_KEY, String.valueOf(serverStartUpTime));
            metadata.put(WEIGHT_KEY, String.valueOf(100));
            if (this.discoveryMetadataRegisters != null) {
                for (DiscoveryMetadataRegister register : this.discoveryMetadataRegisters) {
                    register.registerMetadata(metadata);
                }
            }
            this.applicationInfoManager.registerAppMetadata(metadata);
        }
    }
}

