/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.javaagent;

import cn.com.duibaboot.ext.autoconfigure.DuibaBootVersion;
import cn.com.duibaboot.ext.autoconfigure.javaagent.PluginAgent;
import com.ea.agentloader.AgentLoader;
import com.ea.agentloader.ClassPathUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.JarURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.Enumeration;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.SpringApplicationRunListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;

public class AttachJavaAgentListener
implements SpringApplicationRunListener {
    private static final Logger logger = LoggerFactory.getLogger(AttachJavaAgentListener.class);
    private static final String BOOT_INF_LIB_PREFIX = "BOOT-INF/lib/";
    private static final String BYTE_BYDDY_PREFIX = "byte-buddy";
    private static final String SPRING_BOOT_EXT_PREFIX_PREFIX = "BOOT-INF/lib/spring-boot-ext-";
    private SpringApplication application;
    private static boolean startingCalled = false;

    public AttachJavaAgentListener(SpringApplication application, String[] args) {
        this.application = application;
    }

    public void started() {
        this.starting();
    }

    public void starting() {
        if (!startingCalled) {
            startingCalled = true;
            this.loadJavaAgent();
        }
    }

    private void loadJavaAgent() {
        if (this.noagent()) {
            return;
        }
        if (this.isJarInJarMode()) {
            String jarPath;
            String agentClass = "cn.com.duibaboot.ext.autoconfigure.javaagent.PluginAgentDelegate";
            try {
                this.writeRequiredJar();
                jarPath = this.writeAgentClassesIntoJar(agentClass);
            }
            catch (IOException | URISyntaxException e) {
                throw new RuntimeException(e);
            }
            AgentLoader.loadAgent((String)jarPath, null);
        } else {
            AgentLoader.loadAgentClass((String)PluginAgent.class.getName(), null);
        }
    }

    private boolean noagent() {
        String noagent = System.getProperty("duiba.noagent", "false");
        return "true".equals(noagent);
    }

    private boolean isJarInJarMode() {
        return AttachJavaAgentListener.class.getClassLoader() != ClassLoader.getSystemClassLoader();
    }

    private String writeAgentClassesIntoJar(String agentClass) throws IOException, URISyntaxException {
        File jarFile = File.createTempFile(".javaagent/javaagent." + agentClass, ".jar");
        jarFile.deleteOnExit();
        this.createAgentJar(new FileOutputStream(jarFile), agentClass, null, true, true, false);
        return jarFile.toString();
    }

    private void createAgentJar(OutputStream out, String agentClass, String bootClassPath, boolean canRedefineClasses, boolean canRetransformClasses, boolean canSetNativeMethodPrefix) throws IOException, URISyntaxException {
        Manifest man = new Manifest();
        man.getMainAttributes().put(Attributes.Name.MANIFEST_VERSION, "1.0");
        man.getMainAttributes().putValue("Agent-Class", agentClass);
        if (bootClassPath != null) {
            man.getMainAttributes().putValue("Boot-Class-Path", bootClassPath);
        }
        man.getMainAttributes().putValue("Can-Redefine-Classes", Boolean.toString(canRedefineClasses));
        man.getMainAttributes().putValue("Can-Retransform-Classes", Boolean.toString(canRetransformClasses));
        man.getMainAttributes().putValue("Can-Set-Native-Method-Prefix", Boolean.toString(canSetNativeMethodPrefix));
        JarOutputStream jarOut = new JarOutputStream(out, man);
        this.appendAgentClassToJar(agentClass, jarOut);
        jarOut.flush();
        jarOut.close();
    }

    private void writeRequiredJar() throws URISyntaxException, IOException {
        String rootJarUrlStr = this.getRootJarUrl();
        URL rootJarUrl = new URL(rootJarUrlStr);
        JarURLConnection conn = (JarURLConnection)rootJarUrl.openConnection();
        JarFile jarFile = conn.getJarFile();
        Enumeration<JarEntry> entrys = jarFile.entries();
        while (entrys.hasMoreElements()) {
            JarEntry entry = entrys.nextElement();
            String entryName = entry.getName();
            if (!entryName.startsWith("BOOT-INF/lib/byte-buddy")) continue;
            String nestedUrl = rootJarUrlStr + entry.getName() + "!/";
            String fileName = entryName.substring(BOOT_INF_LIB_PREFIX.length(), entryName.length() - ".jar".length());
            fileName = ".javaagent/" + fileName;
            URL url = this.writeJar(nestedUrl, fileName);
            ClassPathUtils.appendToSystemPath((URL)url);
        }
    }

    private String getRootJarUrl() throws URISyntaxException {
        File root;
        int idx;
        String path;
        ProtectionDomain protectionDomain = this.getClass().getProtectionDomain();
        CodeSource codeSource = protectionDomain.getCodeSource();
        URI location = codeSource == null ? null : codeSource.getLocation().toURI();
        String string = path = location == null ? null : location.getSchemeSpecificPart();
        if (path == null) {
            throw new IllegalStateException("Unable to determine code source archive");
        }
        if (path.startsWith("file:")) {
            path = path.substring("file:".length());
        }
        if ((idx = path.indexOf("!/")) > 0) {
            path = path.substring(0, idx);
        }
        if (!(root = new File(path)).exists()) {
            throw new IllegalStateException("Unable to determine code source archive from " + root);
        }
        String file = root.toURI() + "!/";
        file = file.replace("file:////", "file://");
        file = file.replace("file:/", "jar:file:/");
        return file;
    }

    private URL writeJar(String url, String fileName) throws IOException {
        boolean isSnapShot = fileName.endsWith("-SNAPSHOT");
        URLConnection connection = new URL(url).openConnection();
        String userHome = System.getenv("user.home");
        if (!userHome.endsWith("/")) {
            userHome = userHome + "/";
        }
        File file = null;
        if (!isSnapShot) {
            file = new File(userHome + fileName + ".jar");
            if (file.exists()) {
                URL targetUrl = file.toURI().toURL();
                logger.info("jar file:{} exists, use it", (Object)targetUrl);
                return targetUrl;
            }
            file.getParentFile().mkdirs();
        }
        File tmpFile = null;
        if (!isSnapShot) {
            try {
                tmpFile = File.createTempFile("tmp", "jar.tmp", file.getParentFile());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (tmpFile == null) {
            tmpFile = File.createTempFile(fileName, ".jar");
            tmpFile.deleteOnExit();
            file = null;
        }
        if (connection instanceof JarURLConnection) {
            JarFile jarFile = ((JarURLConnection)connection).getJarFile();
            try (JarOutputStream jarOut = new JarOutputStream(new FileOutputStream(tmpFile));){
                Enumeration<JarEntry> e = jarFile.entries();
                while (e.hasMoreElements()) {
                    JarEntry jarEntry = e.nextElement();
                    jarOut.putNextEntry(jarEntry);
                    InputStream in = jarFile.getInputStream(jarEntry);
                    Throwable throwable = null;
                    try {
                        int n;
                        byte[] bs = new byte[4096];
                        while ((n = in.read(bs)) != -1) {
                            jarOut.write(bs, 0, n);
                        }
                        jarOut.closeEntry();
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (in == null) continue;
                        if (throwable != null) {
                            try {
                                in.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        in.close();
                    }
                }
            }
        }
        throw new IllegalStateException("[NOTIFYME] should not be here");
        if (file != null) {
            boolean success = tmpFile.renameTo(file);
            if (!success && !file.exists()) {
                throw new IllegalStateException("[NOTIFYME] should not be here");
            }
        } else {
            file = tmpFile;
        }
        URL targetUrl = file.toURI().toURL();
        logger.info("jar file:{} written completed", (Object)targetUrl);
        return targetUrl;
    }

    private void appendAgentClassToJar(String agentClass, JarOutputStream jarOut) throws IOException, URISyntaxException {
        int n;
        String rootJarUrlStr = this.getRootJarUrl();
        String nestedSpringBootExtUrlStr = rootJarUrlStr + SPRING_BOOT_EXT_PREFIX_PREFIX + DuibaBootVersion.getVersion() + ".jar!/";
        URL nestedSpringBootExtUrl = new URL(nestedSpringBootExtUrlStr);
        JarURLConnection conn = (JarURLConnection)nestedSpringBootExtUrl.openConnection();
        JarFile jarFile = conn.getJarFile();
        String agentClassentryName = agentClass.replaceAll("\\.", "/").concat(".class");
        JarEntry jarEntry = jarFile.getJarEntry(agentClassentryName);
        jarOut.putNextEntry(jarEntry);
        InputStream in = jarFile.getInputStream(jarEntry);
        byte[] bs = new byte[1024];
        while ((n = in.read(bs)) != -1) {
            jarOut.write(bs, 0, n);
        }
        jarOut.closeEntry();
    }

    public void environmentPrepared(ConfigurableEnvironment environment) {
    }

    public void contextPrepared(ConfigurableApplicationContext context) {
    }

    public void contextLoaded(ConfigurableApplicationContext context) {
    }

    public void finished(ConfigurableApplicationContext context, Throwable exception) {
    }
}

