package cn.com.duibaboot.ext.autoconfigure.jackson;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.module.SimpleModule;
import org.springframework.aop.framework.Advised;

import static com.fasterxml.jackson.annotation.JsonInclude.Include;

/**
 * jackson module, 经过Spring代理过的类在使用jackson序列化成json时防止把代理相关的属性也序列化
 * 主要作用：配合用户鉴权的Consumer/App信息延迟加载使用(biz-tool中的RequestLocal类中有用到)。
 */
public class ProxyedClassJacksonModule extends SimpleModule {

  @Override
  public void setupModule(SetupContext context) {
    super.setupModule(context);
    context.setMixInAnnotations(Advised.class, CustomizedProxyedClassSerializer.class);
  }

  @JsonAutoDetect
  @JsonInclude(value = Include.NON_NULL)//只序列化非null的值
  @JsonIgnoreProperties({"targetSource","proxyTargetClass","targetClass","advisors","exposeProxy","preFiltered","proxiedInterfaces"})
  private class CustomizedProxyedClassSerializer {//extends JsonSerializer<Advised>
    //    @Override
    //    public void serialize(Advised value, JsonGenerator gen, SerializerProvider serializers) throws IOException, JsonProcessingException {
    //      serializers.defaultSerializeValue(value, gen);
    //    }
  }

}
