package cn.com.duibaboot.ext.autoconfigure.perftest;

import java.io.IOException;

import net.bytebuddy.agent.ByteBuddyAgent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.SpringApplicationRunListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;

/**
 *应用启动后附加PluginAgent进行拦截
 */
public class AttachAgentListener implements SpringApplicationRunListener {

    private static final Logger logger = LoggerFactory.getLogger(AttachAgentListener.class);

    private SpringApplication application;

    private static boolean startingCalled = false;

    /**
     * 必须有这个构造函数，否则spring无法初始化该类
     * @param application
     * @param args
     */
    public AttachAgentListener(SpringApplication application, String[] args) {
        this.application = application;
    }

    //@Override //boot新版本没有这个方法，故去掉Override
    public void started() {
        this.starting();
    }

    // boot 1.5.2 新版本有这个方法，故要实现
    //@Override
    public void starting() {
        if(!startingCalled){
            startingCalled = true;
            try {
                PluginAgent.agentmain("", ByteBuddyAgent.install());
            } catch (IOException e) {
               logger.error(e.getMessage(),e);
            }
        }
    }

    //@Override
    public void environmentPrepared(ConfigurableEnvironment environment) {

    }

    //@Override
    public void contextPrepared(ConfigurableApplicationContext context) {

    }

    //@Override
    public void contextLoaded(ConfigurableApplicationContext context) {

    }

    @Override
    public void finished(final ConfigurableApplicationContext context, Throwable exception) {
    }

}
