package cn.com.duibaboot.ext.autoconfigure.perftest;

/**
 * Created by hujinliang on 2017/11/6.
 */

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.instrument.Instrumentation;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.jar.JarFile;

import net.bytebuddy.agent.ByteBuddyAgent;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * 根据properties中配置的路径把jar和配置文件加载到classpath中。
 *
 * @author guo.yang
 */
public class ExtClasspathLoader {
    /**
     * URLClassLoader的addURL方法
     */
    private static final Logger logger = LoggerFactory.getLogger(ExtClasspathLoader.class);
    private static final String PLUGIN_CLASS_NAME = "cn.com.duibaboot.ext.autoconfigure.perftest.PluginAgent";
    public static Instrumentation instrumentation;


    public static Class initInstrumentation() {
        try {
            instrumentation = getInstrumentation();
            return ensureDispatcherIsAppendedToBootstrapClasspath(instrumentation);

        } catch (Exception e) {
            final String msg = "Failed to perform runtime attachment of the  agent";
            logger.warn(msg, e);
            return null;
        }
    }

    private static Instrumentation getInstrumentation() {
        try {
            return ByteBuddyAgent.getInstrumentation();
        } catch (IllegalStateException e) {
            return ByteBuddyAgent.install(
                    new ByteBuddyAgent.AttachmentProvider.Compound(
                            ByteBuddyAgent.AttachmentProvider.DEFAULT));
        }
    }

    private static Class ensureDispatcherIsAppendedToBootstrapClasspath(Instrumentation instrumentation)
            throws ClassNotFoundException, IOException {
        final ClassLoader bootstrapClassloader = ClassLoader.getSystemClassLoader().getParent();
        try {
            return bootstrapClassloader.loadClass(PLUGIN_CLASS_NAME);
            // already injected
        } catch (ClassNotFoundException e) {
            final JarFile jarfile = new JarFile(createTempDispatcherJar());
            instrumentation.appendToBootstrapClassLoaderSearch(jarfile);
            return bootstrapClassloader.loadClass(PLUGIN_CLASS_NAME);
        }
    }

    private static File createTempDispatcherJar() throws IOException {
        final InputStream input = ExtClasspathLoader.class.getClassLoader()
                .getResourceAsStream("spring-boot-ext.jar.gradlePleaseDontExtract");
        if (input == null) {
            throw new IllegalStateException("If you see this exception inside you IDE, you have to execute gradle " +
                    "processResources before running the tests.");
        }
        final File tempDispatcherJar = File.createTempFile("spring-boot-ext", ".jar");
        tempDispatcherJar.deleteOnExit();
        IOUtils.copy(input, new FileOutputStream(tempDispatcherJar));
        return tempDispatcherJar;
    }
}