/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.web.mvc;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.Feature;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.lang.ArrayUtils;
import org.springframework.core.CollectionFactory;
import org.springframework.core.MethodParameter;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;

public class AdvancedFeignClientArgumentResolver
implements HandlerMethodArgumentResolver {
    public boolean supportsParameter(MethodParameter parameter) {
        Class<?>[] interfaces;
        for (Class<?> clazz : interfaces = parameter.getContainingClass().getInterfaces()) {
            if (!clazz.isAnnotationPresent(AdvancedFeignClient.class)) continue;
            return true;
        }
        return false;
    }

    public Object resolveArgument(MethodParameter parameter, ModelAndViewContainer mavContainer, NativeWebRequest webRequest, WebDataBinderFactory binderFactory) throws Exception {
        Object arg = this.resolveJsonArgument(parameter, mavContainer, webRequest, binderFactory);
        ArrayList<Object> argList = (ArrayList<Object>)webRequest.getAttribute("Http-Req-Attr-Rpc-Args", 0);
        if (argList == null) {
            argList = new ArrayList<Object>();
            webRequest.setAttribute("Http-Req-Attr-Rpc-Args", argList, 0);
        }
        argList.add(arg);
        return arg;
    }

    public Object resolveJsonArgument(MethodParameter parameter, ModelAndViewContainer mavContainer, NativeWebRequest webRequest, WebDataBinderFactory binderFactory) throws Exception {
        int parameterIndex = parameter.getParameterIndex();
        String parameteyKeyInRequest = "_p" + parameterIndex;
        Object[] vals = webRequest.getParameterValues(parameteyKeyInRequest);
        Type parameterType = parameter.getGenericParameterType();
        boolean isIterableType = this.isParamIterableType(parameter.getParameterType());
        boolean isCollectionSplitted = false;
        if ("1".equals(webRequest.getHeader("Param-Collection-Splitted"))) {
            isCollectionSplitted = true;
        }
        if (ArrayUtils.isEmpty((Object[])vals)) {
            if (isIterableType) {
                return this.createCollection(parameter, (String[])vals, isCollectionSplitted);
            }
            return null;
        }
        try {
            if (!isIterableType) {
                if (vals.length == 1) {
                    return JSON.parseObject((String)vals[0], (Type)parameterType, (Feature[])new Feature[0]);
                }
                throw this.genIllegalArgumentException(isCollectionSplitted, parameter, (String[])vals);
            }
            if (isCollectionSplitted || !isCollectionSplitted && vals.length > 1) {
                Collection<Object> target = this.createCollection(parameter, (String[])vals, isCollectionSplitted);
                return target;
            }
            return JSON.parseObject((String)vals[0], (Type)parameterType, (Feature[])new Feature[0]);
        }
        catch (IllegalArgumentException e1) {
            throw e1;
        }
        catch (Exception e) {
            throw this.genIllegalArgumentException(isCollectionSplitted, parameter, (String[])vals, e);
        }
    }

    private Collection<Object> createCollection(MethodParameter parameter, String[] vals, boolean isCollectionSplitted) {
        Class clazz = parameter.getParameterType();
        Type parameterType = parameter.getGenericParameterType();
        if (!ParameterizedType.class.isAssignableFrom(parameterType.getClass())) {
            throw this.genIllegalArgumentException(isCollectionSplitted, parameter, vals);
        }
        Type actualType = ((ParameterizedType)parameterType).getActualTypeArguments()[0];
        Collection target = CollectionFactory.createCollection((Class)clazz, (Class)(actualType instanceof Class ? (Class)actualType : null), (int)(vals == null ? 0 : vals.length));
        if (!ArrayUtils.isEmpty((Object[])vals)) {
            for (String val : vals) {
                target.add(JSON.parseObject((String)val, (Type)actualType, (Feature[])new Feature[0]));
            }
        }
        return target;
    }

    private boolean isParamIterableType(Class clazz) {
        return Iterable.class.isAssignableFrom(clazz);
    }

    private IllegalArgumentException genIllegalArgumentException(boolean isCollectionSplitted, MethodParameter p, String[] vals, Exception cause) {
        String msg = String.format("error invoking mvc method: %s, because cannot convert from StringArray:#%s# to parameter of type:%s (isCollectionSplitted:%s)(param index:%d)", p.getMethod().getDeclaringClass().getSimpleName() + "." + p.getMethod().getName(), Arrays.toString(vals), p.getGenericParameterType().getTypeName(), isCollectionSplitted ? "true" : "false", p.getParameterIndex());
        if (cause == null) {
            return new IllegalArgumentException(msg);
        }
        return new IllegalArgumentException(msg, cause);
    }

    private IllegalArgumentException genIllegalArgumentException(boolean isCollectionSplitted, MethodParameter parameter, String[] vals) {
        throw this.genIllegalArgumentException(isCollectionSplitted, parameter, vals, null);
    }
}

