/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.perftest.binaryjedis;

import cn.com.duiba.boot.perftest.PerfTestContext;
import cn.com.duibaboot.ext.autoconfigure.javaagent.core.interceptor.enhance.EnhancedInstance;
import cn.com.duibaboot.ext.autoconfigure.javaagent.core.interceptor.enhance.InstanceMethodsAroundInterceptor;
import cn.com.duibaboot.ext.autoconfigure.javaagent.core.interceptor.enhance.MethodInterceptResult;
import com.alibaba.ttl.TransmittableThreadLocal;
import com.google.common.base.MoreObjects;
import java.lang.reflect.Method;
import redis.clients.jedis.BinaryJedis;

public class BinaryJedisMethodInterceptor
implements InstanceMethodsAroundInterceptor {
    private static final Integer PERF_INDEX = 1;
    private final TransmittableThreadLocal<Integer> perfMode = new TransmittableThreadLocal();

    @Override
    public void beforeMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, MethodInterceptResult result) throws Throwable {
        if (PerfTestContext.isCurrentInPerfTestMode()) {
            Integer state = (Integer)MoreObjects.firstNonNull((Object)this.perfMode.get(), (Object)0);
            state = state + 1;
            this.perfMode.set((Object)state);
            if (state > 1) {
                return;
            }
            PerfTestContext.debugInfo((String)"BinaryJedis");
            BinaryJedis jedis = (BinaryJedis)objInst;
            jedis.select(jedis.getDB().intValue() + PERF_INDEX);
        }
    }

    @Override
    public Object afterMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Object ret) throws Throwable {
        if (PerfTestContext.isCurrentInPerfTestMode()) {
            Integer state = (Integer)this.perfMode.get();
            state = state - 1;
            this.perfMode.set((Object)state);
            if (state == 0) {
                BinaryJedis jedis = (BinaryJedis)objInst;
                jedis.select(jedis.getDB().intValue() - PERF_INDEX);
                this.perfMode.remove();
            }
        }
        return ret;
    }

    @Override
    public void handleMethodException(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Throwable t) {
    }
}

