package cn.com.duibaboot.ext.autoconfigure.data.hbase;

import org.apache.hadoop.conf.Configuration;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.data.hadoop.hbase.HbaseConfigurationFactoryBean;

import java.util.Properties;

@ConfigurationProperties(prefix = "duiba.hbase")
public class HbaseProperties {

    /**
     * the HBase Zookeeper Quorum host(s)(comma split, without port). default is localhost；这个配置对应的配置key为：hbase.zookeeper.quorum
     */
    private String zkQuorum;

    /**
     * the HBase Zookeeper port for clients to connect to. default 2181；这个配置对应的配置key为：hbase.zookeeper.property.clientPort
     */
    private Integer zkPort;

    /**
     * 该参数表示一次RPC请求的超时时间(单位：ms)，该值默认为5秒; 这个配置对应的配置key为：hbase.rpc.timeout
     */
    private Integer rpcTimeout = 5000;

    /**
     * 操作超时时间(单位：ms)，该值默认为10秒,这个配置对应的配置key为：hbase.client.operation.timeout
     * <br/>
     * 该参数表示HBase客户端发起一次数据操作直至得到响应之间总的超时时间，数据操作类型包括get、append、increment、delete、put等。该值与hbase.rpc.timeout的区别为,hbase.rpc.timeout为一次rpc调用的超时时间。而hbase.client.operation.timeout为一次操作总的时间(从开始调用到重试n次之后失败的总时间)。
     */
    private Integer operationTimeout = 10000;

    /**
     * 失败重试时等待时间(ms)，默认20ms，这个配置对应的配置key为：hbase.client.pause
     * <br/>
     * 随着重试次数越多,重试等待时间越长，如果重试10次, hbase.client.pause=50ms，则每次重试等待时间为{50ms，100ms，150ms，250ms，500ms，1000ms，2000ms，5000ms，5000ms，5000ms}。
     */
    private Integer pause = 20;

    /**
     * 失败时重试次数, 默认10次，这个配置对应的配置key为：hbase.client.retries.number
     */
    private Integer retriesNumber = 10;

    /**
     * scan操作总超时时间（单位：ms），默认为60秒，这个配置对应的配置key为：hbase.client.scanner.timeout.period
     * <br/>
     * 该参数是表示HBase客户端发起一次scan操作的rpc调用至得到响应之间总的超时时间。一次scan操作是指发起一次regionserver rpc调用的操作,hbase会根据scan查询条件的cacheing、batch设置将scan操作会分成多次rpc操作。比如满足scan条件的rowkey数量为10000个，scan查询的cacheing=200，则查询所有的结果需要执行的rpc调用次数为50个。而该值是指50个rpc调用的单个相应时间的最大值。
     */
    private Integer scannerTimeoutPeriod = 60000;

    /**
     * Additional Hbase properties.
     */
    private Properties properties;

    private Configuration configuration;

    public String getZkQuorum() {
        return zkQuorum;
    }

    public void setZkQuorum(String zkQuorum) {
        this.zkQuorum = zkQuorum;
    }

    public Integer getZkPort() {
        return zkPort;
    }

    public void setZkPort(Integer zkPort) {
        this.zkPort = zkPort;
    }

    public Properties getProperties() {
        return properties;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public Integer getOperationTimeout() {
        return operationTimeout;
    }

    public void setOperationTimeout(Integer operationTimeout) {
        this.operationTimeout = operationTimeout;
    }

    public Integer getRpcTimeout() {
        return rpcTimeout;
    }

    public void setRpcTimeout(Integer rpcTimeout) {
        this.rpcTimeout = rpcTimeout;
    }

    public Integer getPause() {
        return pause;
    }

    public void setPause(Integer pause) {
        this.pause = pause;
    }

    public Integer getRetriesNumber() {
        return retriesNumber;
    }

    public void setRetriesNumber(Integer retriesNumber) {
        this.retriesNumber = retriesNumber;
    }

    public Integer getScannerTimeoutPeriod() {
        return scannerTimeoutPeriod;
    }

    public void setScannerTimeoutPeriod(Integer scannerTimeoutPeriod) {
        this.scannerTimeoutPeriod = scannerTimeoutPeriod;
    }

    /**
     * 得到对应的hbase的配置对象
     * @return
     */
    public synchronized Configuration getConfiguration(){
        if(configuration == null){
            HbaseConfigurationFactoryBean config = new HbaseConfigurationFactoryBean();
            config.setZkQuorum(this.getZkQuorum());
            config.setZkPort(this.getZkPort());
            config.setProperties(properties);
            config.afterPropertiesSet();
            configuration = config.getObject();
        }

        return configuration;
    }
}
