package cn.com.duibaboot.ext.autoconfigure.perftest.binaryjedis;

import static net.bytebuddy.matcher.ElementMatchers.isOverriddenFrom;
import static net.bytebuddy.matcher.ElementMatchers.named;

import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.matcher.ElementMatcher;
import redis.clients.jedis.AdvancedBinaryJedisCommands;
import redis.clients.jedis.BinaryJedisCommands;
import redis.clients.jedis.BinaryScriptingCommands;
import redis.clients.jedis.MultiKeyBinaryCommands;

public enum BinaryRedisMethodMatch {
    INSTANCE;

    public ElementMatcher<MethodDescription> getJedisMethodMatcher() {
        return isOverriddenFrom(BinaryJedisCommands.class).or(isOverriddenFrom(MultiKeyBinaryCommands.class)
                .or(isOverriddenFrom(BinaryScriptingCommands.class)))
                .or(isOverriddenFrom(AdvancedBinaryJedisCommands.class)).or(named("flushDB"));

    }
}
