package cn.com.duibaboot.ext.autoconfigure.web;

import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.web.WebMvcAutoConfiguration;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.Ordered;
import org.springframework.web.servlet.DispatcherServlet;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;

import javax.servlet.DispatcherType;
import javax.servlet.Servlet;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;

/**
 * 给web应用自动配置监控url，访问http://localhost:${port}/monitor/check即可识别出服务器状态是否正常(OK表示正常，INVALID表示服务关闭),
 * 访问http://localhost:${port}/monitor/stop可以让check接口返回INVALID,
 * 访问http://localhost:${port}/monitor/start可以让check接口返回OK.
 * 其中start和stop接口限制了只能通过本机访问。
 * 这三个接口供给nginx或slb等负载均衡器做健康检查、优雅停机用，当应用启动，默认check接口返回OK，负载均衡把这个机器作为后端服务器（负载均衡会每隔1s检查一次这个接口状态，如果状态不正常，则把这个机器从后端服务器列表暂时排除），
 * 当需要关闭应用时，发布脚本先调用stop接口，等待3s左右，让负载均衡有机会检测到应用已停用，然后发布脚本再开始真正停止应用。如果没有这个优雅停机的过程，在应用关闭的时候，负载均衡仍然会把请求转发给这台机器，导致部分用户看到报错页面。（目前Tengine可以设置请求某个后端服务器错误时自动请求其他服务器，但这会增加rt。）
 */
@Configuration
@AutoConfigureAfter({WebMvcAutoConfiguration.class})
@ConditionalOnClass({ Servlet.class, DispatcherServlet.class,
        WebMvcConfigurerAdapter.class })
@ConditionalOnWebApplication
public class WebMvcMonitorAutoConfiguration {

//    @Bean
//    @ConditionalOnMissingBean(BootMonitorController.class)
//    public BootMonitorController bootMonitorController(){
//        return new BootMonitorController();
//    }

    /**
     * 为了防止健康检查URL被应用内的LoginFilter登录拦截器拦截而跳转302，由原来的直接使用Controller改为使用Filter
     */
    @Configuration
    @ConditionalOnClass({ Servlet.class, DispatcherServlet.class,
            WebMvcConfigurerAdapter.class })
    @ConditionalOnWebApplication
    public static class bootMonitorCheckFilterConfiguration{
        @Bean
        public FilterRegistrationBean bootMonitorCheckFilterConfigurer(){
            BootMonitorCheckFilter filter=new BootMonitorCheckFilter();
            FilterRegistrationBean registrationBean = new FilterRegistrationBean();
            registrationBean.setFilter(filter);
            List<String> urlPatterns=new ArrayList<String>();
            urlPatterns.add("/monitor/*");//拦截路径，可以添加多个
            registrationBean.setUrlPatterns(urlPatterns);
            registrationBean.setDispatcherTypes(EnumSet.of(DispatcherType.REQUEST));
            registrationBean.setOrder(Ordered.HIGHEST_PRECEDENCE);//最高优先级
            return registrationBean;
        }
    }
}
