/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.javaagent.core;

import cn.com.duibaboot.ext.autoconfigure.javaagent.core.AbstractClassEnhancePluginDefine;
import cn.com.duibaboot.ext.autoconfigure.javaagent.core.bytebuddy.AbstractJunction;
import cn.com.duibaboot.ext.autoconfigure.javaagent.core.match.ClassMatch;
import cn.com.duibaboot.ext.autoconfigure.javaagent.core.match.IndirectMatch;
import cn.com.duibaboot.ext.autoconfigure.javaagent.core.match.NameMatch;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.bytebuddy.description.NamedElement;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;

public class PluginFinder {
    private final Map<String, AbstractClassEnhancePluginDefine> nameMatchDefine = new HashMap<String, AbstractClassEnhancePluginDefine>();
    private final List<AbstractClassEnhancePluginDefine> signatureMatchDefine = new LinkedList<AbstractClassEnhancePluginDefine>();

    public PluginFinder(List<AbstractClassEnhancePluginDefine> plugins) {
        for (AbstractClassEnhancePluginDefine plugin : plugins) {
            ClassMatch match = plugin.enhanceClass();
            if (match == null) continue;
            if (match instanceof NameMatch) {
                NameMatch nameMatch = (NameMatch)match;
                this.nameMatchDefine.put(nameMatch.getClassName(), plugin);
                continue;
            }
            this.signatureMatchDefine.add(plugin);
        }
    }

    public AbstractClassEnhancePluginDefine find(TypeDescription typeDescription, ClassLoader classLoader) {
        String typeName = typeDescription.getTypeName();
        if (this.nameMatchDefine.containsKey(typeName)) {
            return this.nameMatchDefine.get(typeName);
        }
        for (AbstractClassEnhancePluginDefine pluginDefine : this.signatureMatchDefine) {
            IndirectMatch match = (IndirectMatch)pluginDefine.enhanceClass();
            if (!match.isMatch(typeDescription)) continue;
            return pluginDefine;
        }
        return null;
    }

    public ElementMatcher<? super TypeDescription> buildMatch() {
        AbstractJunction<NamedElement> judge = new AbstractJunction<NamedElement>(){

            public boolean matches(NamedElement target) {
                return PluginFinder.this.nameMatchDefine.containsKey(target.getActualName());
            }
        };
        judge = judge.and((ElementMatcher)ElementMatchers.not((ElementMatcher)ElementMatchers.isInterface()));
        for (AbstractClassEnhancePluginDefine define : this.signatureMatchDefine) {
            ClassMatch match = define.enhanceClass();
            if (!(match instanceof IndirectMatch)) continue;
            judge = judge.or((ElementMatcher)((IndirectMatch)match).buildJunction());
        }
        return judge;
    }
}

