package cn.com.duibaboot.ext.autoconfigure.actuate;

import cn.com.duiba.wolf.perf.timeprofile.RequestTool;
import cn.com.duibaboot.ext.autoconfigure.core.utils.HttpRequestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.actuate.endpoint.mvc.MvcEndpointSecurityInterceptor;
import org.springframework.http.HttpStatus;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * 自定义的安全拦截器，对于/refresh， /restart等http接口，只要是内网触发的，则允许执行
 */
public class CustomMvcEndpointSecurityInterceptor extends MvcEndpointSecurityInterceptor {
    private static final Logger logger = LoggerFactory.getLogger(CustomMvcEndpointSecurityInterceptor.class);

    public CustomMvcEndpointSecurityInterceptor() {
        super(true, null);
    }

    @Override
    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        boolean isLanReq = HttpRequestUtils.isLanRequest(request);
        if(!isLanReq){
            sendFailureResponse(request, response);
        }
        return isLanReq;
    }

    private void sendFailureResponse(HttpServletRequest request,
                                     HttpServletResponse response) throws Exception {
        logUnauthorizedAttempt(request);
        response.sendError(HttpStatus.FORBIDDEN.value(),
                "Access is denied. ");
    }

    private void logUnauthorizedAttempt(HttpServletRequest request) {
        logger.warn("Someone from internet[ip:{}] try to access actuator endpoints:[{}], Deny this request", RequestTool.getIpAddr(request), request.getRequestURI());
    }
}
