package cn.com.duibaboot.ext.autoconfigure.core.utils;

public final class SpringBootUtils {
    private SpringBootUtils(){}

    /**
     * 是否运行在spring jar in jar模式下
     */
    public static boolean isJarInJarMode(){
        Class<?> restartClassLoaderClass = null;
        try {
            restartClassLoaderClass = Class.forName("org.springframework.boot.devtools.restart.classloader.RestartClassLoader");
        } catch (ClassNotFoundException e) {
            //Ignore
        }

        //ClassLoader.getSystemClassLoader() 即 AppClassLoader
        if(SpringBootUtils.class.getClassLoader() != ClassLoader.getSystemClassLoader()
                && SpringBootUtils.class.getClassLoader().getClass() != restartClassLoaderClass) {
            return true;
        }
        return false;
    }
}
