package cn.com.duiba.boot.ext.autoconfigure.cloud.netflix.discovery;

import com.netflix.appinfo.ApplicationInfoManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.context.annotation.Configuration;

import javax.annotation.PostConstruct;
import java.util.HashMap;
import java.util.Map;

/**
 * 注册一些额外的元数据到Eureka（Consul）中，比如服务器启动时间。
 */
@Configuration
@ConditionalOnBean(ApplicationInfoManager.class)
public class DiscoveryMetadataAutoConfiguration {
    //服务器启动时间
    private long serverStartUpTime;
    //metadata中的key
    public static final String SERVER_START_UP_TIME_KEY = "serverStartUpTime";
    public static final String WEIGHT_KEY = "weight";

    @Autowired(required = false)
    private ApplicationInfoManager applicationInfoManager;

    @PostConstruct
    public void registerAppMetadata(){
        serverStartUpTime = System.currentTimeMillis();

        if(applicationInfoManager != null) {
            Map<String, String> metadata = new HashMap<>();
            //metadata中放入服务器启动时间
            metadata.put(SERVER_START_UP_TIME_KEY, String.valueOf(serverStartUpTime));
            //metadata中放入服务器权重,默认100
            metadata.put(WEIGHT_KEY, String.valueOf(100));

            applicationInfoManager.registerAppMetadata(metadata);
        }
    }
}
