package cn.com.duiba.boot.ext.autoconfigure.cloud.netflix.feign;

import cn.com.duiba.boot.ext.autoconfigure.core.Constants;
import cn.com.duiba.boot.ext.autoconfigure.core.rpc.RpcContext;
import com.dianping.cat.Cat;
import feign.RequestInterceptor;
import feign.RequestTemplate;

/**
 * Feign请求拦截，在请求头里加入特殊标记，标识这是一个RPC请求，不应该被cat记录为URL请求，而应该被识别为RPC请求；加入cat分布式跟踪id，和当前应用名
 */
public class CustomRequestInterceptor implements RequestInterceptor {

    /**
     * 标识这是rpc请求
     */
    public static final String X_RPC = "X-Rpc";

    @Override
    public void apply(RequestTemplate template) {
        template.header(X_RPC, "true");

        //附加cat分布式跟踪id
        String catRootId = RpcContext.getContext().getAttachment(Cat.Context.ROOT);
        String catChildId = RpcContext.getContext().getAttachment(Cat.Context.CHILD);
        String catParentId = RpcContext.getContext().getAttachment(Cat.Context.PARENT);
        String rpcClient = RpcContext.getContext().getAttachment(Constants.X_RPC_CLIENT);
        if(catRootId != null){
            template.header(Cat.Context.ROOT, catRootId);
        }
        if(catChildId != null){
            template.header(Cat.Context.CHILD, catChildId);
        }
        if(catParentId != null){
            template.header(Cat.Context.PARENT, catParentId);
        }
        //rpc客户端名
        if(rpcClient != null){
            template.header(Constants.X_RPC_CLIENT, rpcClient);
        }
    }
}
