package cn.com.duiba.boot.ext.autoconfigure.core;

import org.springframework.beans.BeansException;
import org.springframework.core.Ordered;

/**
 * 这个类的实例会被BeanPostProecessor调用,参见InitServerAutoConfiguration.specifiedBeanPostProcessorConfigurer
 * Created by wenqi.huang on 2017/6/14.
 */
public interface SpecifiedBeanPostProcessor<T> extends Ordered {

    /**
     * 需要处理的Bean类
     * @return
     */
    Class<T> getBeanType();

    Object postProcessBeforeInitialization(T bean, String beanName) throws BeansException;

    Object postProcessAfterInitialization(T bean, String beanName) throws BeansException;

}
