/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.boot.ext.autoconfigure.cat;

import cn.com.duiba.boot.ext.autoconfigure.core.utils.CatUtils;
import com.dianping.cat.Cat;
import com.dianping.cat.message.Transaction;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.data.redis.connection.jedis.JedisConnection;

@Aspect
public class CatSpringDataRedisPlugin {
    private static final Logger logger = LoggerFactory.getLogger(CatSpringDataRedisPlugin.class);
    private volatile Class<?> lastJedisConnectionProxyClass;

    @Around(value="execution(* org.springframework.data.redis.connection.jedis.JedisConnectionFactory.getConnection(..))")
    public Object springDataRedisJoinPoint(ProceedingJoinPoint joinPoint) throws Throwable {
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        String methodName = signature.getMethod().getName();
        if (CatUtils.isCatEnabled() && "getConnection".equals(methodName)) {
            try {
                JedisConnection connection = (JedisConnection)joinPoint.proceed();
                ProxyFactory factory = new ProxyFactory();
                factory.setTarget((Object)connection);
                factory.addAdvice((Advice)new JedisConnectionMethodInterceptor());
                JedisConnection newConnection = (JedisConnection)factory.getProxy();
                if (this.lastJedisConnectionProxyClass != null && this.lastJedisConnectionProxyClass != newConnection.getClass()) {
                    logger.error("JedisConnectionProxyClass is not same\uff0cthis is spring's bug,please upgrade spring-boot's version to 1.3.8.RELEASE or higher! {},{},{},{}", new Object[]{this.getClass().getClassLoader(), newConnection.getClass().getClassLoader(), this.lastJedisConnectionProxyClass, newConnection.getClass()});
                }
                this.lastJedisConnectionProxyClass = newConnection.getClass();
                return newConnection;
            }
            catch (Throwable e) {
                Transaction transaction = Cat.newTransaction((String)"Cache.dataRedis", (String)methodName);
                transaction.setStatus(e);
                transaction.complete();
                throw e;
            }
        }
        return joinPoint.proceed();
    }

    private static Object interceptorRedisMethods(MethodInvocation invocation) throws Throwable {
        String methodName = invocation.getMethod().getName();
        if (methodName.equals("toString") || methodName.equals("hashCode") || methodName.equals("equals")) {
            return invocation.proceed();
        }
        Transaction transaction = "get".equals(methodName) ? Cat.newTransaction((String)"Cache.dataRedis", (String)(methodName + ":" + methodName)) : Cat.newTransaction((String)"Cache.dataRedis", (String)methodName);
        try {
            Object value = invocation.proceed();
            if (value == null && "get".equals(methodName)) {
                Cat.logEvent((String)"Cache.dataRedis", (String)(methodName + ":missed"));
            }
            transaction.setStatus("0");
            Object object = value;
            return object;
        }
        catch (Throwable e) {
            transaction.setStatus(e);
            throw e;
        }
        finally {
            transaction.complete();
        }
    }

    private static class JedisMethodInterceptor
    implements MethodInterceptor {
        JedisMethodInterceptor() {
        }

        public Object invoke(MethodInvocation invocation) throws Throwable {
            return CatSpringDataRedisPlugin.interceptorRedisMethods(invocation);
        }
    }

    private static class JedisConnectionMethodInterceptor
    implements MethodInterceptor {
        JedisConnectionMethodInterceptor() {
        }

        public Object invoke(MethodInvocation invocation) throws Throwable {
            String methodName = invocation.getMethod().getName();
            if (methodName.equals("isPipelined") || methodName.equals("openPipeline") || methodName.equals("isQueueing") || methodName.equals("isClosed") || methodName.equals("close") || methodName.equals("closePipeline")) {
                return invocation.proceed();
            }
            if (methodName.equals("getNativeConnection")) {
                Object nativeConnection = invocation.proceed();
                ProxyFactory factory = new ProxyFactory();
                factory.setTarget(nativeConnection);
                factory.addAdvice((Advice)new JedisMethodInterceptor());
                Object newNativeConnection = factory.getProxy();
                return newNativeConnection;
            }
            return CatSpringDataRedisPlugin.interceptorRedisMethods(invocation);
        }
    }
}

