/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.boot.ext.autoconfigure.cloud.netflix.discovery;

import com.netflix.appinfo.ApplicationInfoManager;
import java.util.HashMap;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnBean(value={ApplicationInfoManager.class})
public class DiscoveryMetadataAutoConfiguration {
    private long serverStartUpTime;
    public static final String SERVER_START_UP_TIME_KEY = "serverStartUpTime";
    public static final String WEIGHT_KEY = "weight";
    @Autowired(required=false)
    private ApplicationInfoManager applicationInfoManager;

    @PostConstruct
    public void registerAppMetadata() {
        this.serverStartUpTime = System.currentTimeMillis();
        if (this.applicationInfoManager != null) {
            HashMap<String, String> metadata = new HashMap<String, String>();
            metadata.put(SERVER_START_UP_TIME_KEY, String.valueOf(this.serverStartUpTime));
            metadata.put(WEIGHT_KEY, String.valueOf(100));
            this.applicationInfoManager.registerAppMetadata(metadata);
        }
    }
}

