/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.boot.ext.autoconfigure.web.mvc;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.Feature;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import org.springframework.core.CollectionFactory;
import org.springframework.core.MethodParameter;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;

public class AdvancedFeignClientArgumentResolver
implements HandlerMethodArgumentResolver {
    public boolean supportsParameter(MethodParameter parameter) {
        Class<?>[] interfaces;
        for (Class<?> clazz : interfaces = parameter.getContainingClass().getInterfaces()) {
            if (!clazz.isAnnotationPresent(AdvancedFeignClient.class)) continue;
            return true;
        }
        return false;
    }

    public Object resolveArgument(MethodParameter parameter, ModelAndViewContainer mavContainer, NativeWebRequest webRequest, WebDataBinderFactory binderFactory) throws Exception {
        int parameterIndex = parameter.getParameterIndex();
        String parameteyKeyInRequest = "_p" + parameterIndex;
        String[] vals = webRequest.getParameterValues(parameteyKeyInRequest);
        if (vals == null || vals.length == 0) {
            return null;
        }
        boolean isCollectionSplitted = false;
        if ("1".equals(webRequest.getHeader("Param-Collection-Splitted"))) {
            isCollectionSplitted = true;
        }
        try {
            Type parameterType = parameter.getGenericParameterType();
            boolean isIterableType = this.isParamIterableType(parameter.getParameterType());
            if (!isIterableType) {
                if (vals.length == 1) {
                    return JSON.parseObject((String)vals[0], (Type)parameterType, (Feature[])new Feature[0]);
                }
                throw this.genIllegalArgumentException(isCollectionSplitted, parameter, vals);
            }
            if (isCollectionSplitted || !isCollectionSplitted && vals.length > 1) {
                Class clazz = parameter.getParameterType();
                if (!ParameterizedType.class.isAssignableFrom(parameterType.getClass())) {
                    throw this.genIllegalArgumentException(isCollectionSplitted, parameter, vals);
                }
                Type actualType = ((ParameterizedType)parameterType).getActualTypeArguments()[0];
                Collection target = CollectionFactory.createCollection((Class)clazz, (Class)(actualType instanceof Class ? (Class)actualType : null), (int)vals.length);
                for (String val : vals) {
                    target.add(JSON.parseObject((String)val, (Type)actualType, (Feature[])new Feature[0]));
                }
                return target;
            }
            return JSON.parseObject((String)vals[0], (Type)parameterType, (Feature[])new Feature[0]);
        }
        catch (IllegalArgumentException e1) {
            throw e1;
        }
        catch (Exception e) {
            throw this.genIllegalArgumentException(isCollectionSplitted, parameter, vals, e);
        }
    }

    private boolean isParamIterableType(Class clazz) {
        return Iterable.class.isAssignableFrom(clazz);
    }

    private IllegalArgumentException genIllegalArgumentException(boolean isCollectionSplitted, MethodParameter p, String[] vals, Exception cause) {
        String msg = String.format("error invoking mvc method: %s, because cannot convert from StringArray:#%s# to parameter of type:%s (isCollectionSplitted:%s)(param index:%d)", p.getMethod().getDeclaringClass().getSimpleName() + "." + p.getMethod().getName(), Arrays.toString(vals), p.getGenericParameterType().getTypeName(), isCollectionSplitted ? "true" : "false", p.getParameterIndex());
        if (cause == null) {
            return new IllegalArgumentException(msg);
        }
        return new IllegalArgumentException(msg, cause);
    }

    private IllegalArgumentException genIllegalArgumentException(boolean isCollectionSplitted, MethodParameter parameter, String[] vals) {
        throw this.genIllegalArgumentException(isCollectionSplitted, parameter, vals, null);
    }
}

