/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.feign;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import feign.Util;
import feign.hystrix.FallbackFactory;
import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.collections.set.SynchronizedSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.cloud.netflix.feign.BaseFeignClientsRegistrar;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.core.type.classreading.MetadataReaderFactory;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.util.StringUtils;

public class CustomFeignClientsRegistrar
extends BaseFeignClientsRegistrar
implements ImportBeanDefinitionRegistrar,
ResourceLoaderAware,
BeanClassLoaderAware {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final int ADVANCED_FEIGN_CLIENT_ANNO_MIN_PACKAGE_LEVEL = 3;
    private static final Set<String> enabledFeignClientNames = SynchronizedSet.decorate(new HashSet());
    private ResourceLoader resourceLoader;
    private ObjectMapper objectMapperForValidate;

    public static Set<String> getEnabledFeignClientNames() {
        return Collections.unmodifiableSet(enabledFeignClientNames);
    }

    @Override
    public void setResourceLoader(ResourceLoader resourceLoader) {
        super.setResourceLoader(resourceLoader);
        this.resourceLoader = resourceLoader;
        this.objectMapperForValidate = new ObjectMapper();
    }

    @Override
    protected ClassPathScanningCandidateComponentProvider getScanner() {
        ClassPathScanningCandidateComponentProvider scanner = super.getScanner();
        this.postHandle(scanner);
        return scanner;
    }

    protected void postHandle(ClassPathScanningCandidateComponentProvider scanner) {
        if (!(this.resourceLoader instanceof ApplicationContext)) {
            this.logger.warn("resourceLoader is not instance of ConfigurableWebApplicationContext, will load all FeignClient");
            return;
        }
        ApplicationContext context = (ApplicationContext)this.resourceLoader;
        String isInUnitTest = context.getEnvironment().getProperty("org.springframework.boot.test.context.SpringBootTestContextBootstrapper");
        String isLoadThisProjectFeignClients = context.getEnvironment().getProperty("duiba.feign.load-this-project-feign-clients");
        if ("true".equals(isInUnitTest) && "true".equals(isLoadThisProjectFeignClients)) {
            return;
        }
        final String applicationName = context.getEnvironment().getProperty("spring.application.name");
        if (applicationName == null || applicationName.isEmpty()) {
            throw new IllegalStateException("property[spring.application.name] is not exist");
        }
        scanner.addExcludeFilter(new TypeFilter(){

            public boolean match(MetadataReader metadataReader, MetadataReaderFactory metadataReaderFactory) throws IOException {
                Map map = metadataReader.getAnnotationMetadata().getAnnotationAttributes(FeignClient.class.getName());
                if (map == null || map.isEmpty()) {
                    return false;
                }
                String name = (String)map.get("name");
                return name.equals(applicationName);
            }
        });
    }

    @Override
    protected void registerFeignClient(BeanDefinitionRegistry registry, AnnotationMetadata annotationMetadata, Map<String, Object> attributes) {
        this.validateMethodArgsAndReturnType(annotationMetadata.getClassName());
        super.registerFeignClient(registry, annotationMetadata, attributes);
        this.registerFeignClientFallBack(registry, annotationMetadata, attributes);
    }

    private void registerFeignClientFallBack(BeanDefinitionRegistry registry, AnnotationMetadata annotationMetadata, Map<String, Object> attributes) {
        Class<?> feignClientClass;
        Class fallbackClazz = (Class)attributes.get("fallback");
        Class fallbackFactoryClazz = (Class)attributes.get("fallbackFactory");
        Class clazzToRegister = null;
        try {
            feignClientClass = Class.forName(annotationMetadata.getClassName());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        if (fallbackClazz != null && !fallbackClazz.equals(Void.TYPE)) {
            clazzToRegister = fallbackClazz;
            if (!feignClientClass.isAssignableFrom(clazzToRegister)) {
                throw new IllegalStateException(String.format("Incompatible fallback instance for feign client %s. instances of '%s', but should instances of '%s'", feignClientClass.getName(), clazzToRegister.getName(), feignClientClass.getName()));
            }
        } else if (fallbackFactoryClazz != null && !fallbackFactoryClazz.equals(Void.TYPE)) {
            Type[] intls;
            clazzToRegister = fallbackFactoryClazz;
            if (!FallbackFactory.class.isAssignableFrom(fallbackFactoryClazz)) {
                throw new IllegalStateException(String.format("%s 's fallbackFactory is invalid,must implements feign.hystrix.FallbackFactory", annotationMetadata.getClassName()));
            }
            for (Type type : intls = fallbackFactoryClazz.getGenericInterfaces()) {
                Class fallbackClazzProduces;
                ParameterizedType ptype;
                if (!(type instanceof ParameterizedType) || !((ptype = (ParameterizedType)type).getRawType() instanceof Class) && !FallbackFactory.class.isAssignableFrom((Class)ptype.getRawType()) || feignClientClass.isAssignableFrom(fallbackClazzProduces = (Class)ptype.getActualTypeArguments()[0])) continue;
                throw new IllegalStateException(String.format("Incompatible fallbackFactory instance for feign client %s. Factory produces instances of '%s', but should produce instances of '%s'", feignClientClass.getName(), fallbackClazzProduces.getName(), feignClientClass.getName()));
            }
        }
        if (clazzToRegister != null) {
            BeanDefinitionBuilder definition = BeanDefinitionBuilder.genericBeanDefinition((Class)clazzToRegister);
            this.validate(attributes);
            definition.setAutowireMode(0);
            AbstractBeanDefinition beanDefinition = definition.getBeanDefinition();
            beanDefinition.setPrimary(false);
            beanDefinition.setAutowireCandidate(false);
            String classSimpleName = clazzToRegister.getSimpleName();
            String beanName = classSimpleName.substring(0, 1).toLowerCase() + (classSimpleName.length() > 1 ? classSimpleName.substring(1) : "");
            BeanDefinitionHolder holder = new BeanDefinitionHolder((BeanDefinition)beanDefinition, beanName);
            BeanDefinitionReaderUtils.registerBeanDefinition((BeanDefinitionHolder)holder, (BeanDefinitionRegistry)registry);
        }
    }

    private void validateMethodArgsAndReturnType(String feignClientClassName) {
        Class<?> feignClientClass;
        try {
            feignClientClass = Class.forName(feignClientClassName);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        for (Method method : feignClientClass.getMethods()) {
            AtomicReference ref;
            JavaType javaType;
            boolean support;
            if (method.getDeclaringClass() == Object.class || (method.getModifiers() & 8) != 0 || Util.isDefault((Method)method)) continue;
            int paramIndex = 0;
            for (Type parameterType : method.getGenericParameterTypes()) {
                AtomicReference ref2;
                JavaType javaType2 = this.objectMapperForValidate.getTypeFactory().constructType(parameterType);
                boolean support2 = this.objectMapperForValidate.canDeserialize(javaType2, ref2 = new AtomicReference());
                if (!support2) {
                    throw new IllegalStateException(String.format("parameter [%s](paramterIndex:%d) of method:[%s] can not be deserialized by json", parameterType.getTypeName(), paramIndex, method.toString()), (Throwable)ref2.get());
                }
                ++paramIndex;
            }
            Type returnType = method.getGenericReturnType();
            if (returnType == Void.TYPE || (support = this.objectMapperForValidate.canDeserialize(javaType = this.objectMapperForValidate.getTypeFactory().constructType(returnType), ref = new AtomicReference()))) continue;
            throw new IllegalStateException(String.format("returnType [%s] of method:[%s] can not be deserialized by json", returnType.getTypeName(), method.toString()), (Throwable)ref.get());
        }
    }

    @Override
    protected void customClientName(Map<String, Object> attributes, String feignClientClassName) {
        String currentPackage;
        int idx;
        if (attributes == null) {
            return;
        }
        String value = (String)attributes.get("value");
        if (!StringUtils.hasText((String)value)) {
            value = (String)attributes.get("name");
        }
        if (!StringUtils.hasText((String)value)) {
            value = (String)attributes.get("serviceId");
        }
        if (!StringUtils.hasText((String)value) && (idx = feignClientClassName.lastIndexOf(".")) != -1 && (value = this.searchAndSetClientNameFromPackageInfo(currentPackage = feignClientClassName.substring(0, idx))) != null) {
            attributes.put("name", value);
            attributes.put("value", value);
        }
        enabledFeignClientNames.add(value);
    }

    private String searchAndSetClientNameFromPackageInfo(String packageName) {
        if (packageName == null) {
            return null;
        }
        Package pkg = Package.getPackage(packageName);
        if (pkg == null) {
            return this.searchAndSetClientNameFromPackageInfo(this.parentPackage(packageName));
        }
        AdvancedFeignClient feignClientAnno = pkg.getAnnotation(AdvancedFeignClient.class);
        if (feignClientAnno == null || !StringUtils.hasText((String)feignClientAnno.name()) && !StringUtils.hasText((String)feignClientAnno.value())) {
            return this.searchAndSetClientNameFromPackageInfo(this.parentPackage(packageName));
        }
        int packageLevel = org.apache.commons.lang3.StringUtils.split((String)packageName, (String)".").length;
        if (packageLevel < 3) {
            throw new IllegalStateException(String.format("@AdvancedFeignClient must be annotated on a package have at least %d levels, current package is : %s, level is: %d", 3, packageName, packageLevel));
        }
        return StringUtils.hasText((String)feignClientAnno.name()) ? feignClientAnno.name() : feignClientAnno.value();
    }

    private String parentPackage(String packageName) {
        int idx = packageName.lastIndexOf(".");
        if (idx == -1) {
            return null;
        }
        return packageName.substring(0, idx);
    }
}

