package cn.com.duiba.boot.ext.autoconfigure.cat;

import cn.com.duiba.boot.ext.autoconfigure.core.utils.CatUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;

import cn.com.duiba.catmonitor.CatInstance;

import com.dianping.cat.Cat;
import com.dianping.cat.message.Message;
import com.dianping.cat.message.Transaction;

@Aspect
public class CatRediscachePlugin {
	
	@Around("execution(* cn.com.duiba.wolf.redis.RedisClient.*(..))")
	public Object redisJoinPoint(ProceedingJoinPoint joinPoint) throws Throwable{
		MethodSignature signature = (MethodSignature) joinPoint.getSignature();
		String methodName = signature.getMethod().getName();
		if(CatUtils.isCatEnabled()){
			Transaction transaction;
			if("get".equals(methodName)){
				transaction = Cat.newTransaction("Cache.redis", methodName + ":" + methodName);
			}else{
				transaction = Cat.newTransaction("Cache.redis", methodName);
			}
			try {
				Object cacheValue = joinPoint.proceed();
				if("get".equals(methodName) && cacheValue == null){
					Cat.logEvent("Cache.redis", methodName + ":missed");
				}
				transaction.setStatus(Message.SUCCESS);
				return cacheValue;
			} catch (Throwable e) {
				Cat.logError(e);
				transaction.setStatus(e);
				throw e;
			}finally{
				transaction.complete();
			}
		}else{
			return joinPoint.proceed();
		}
	}
	
}
