package cn.com.duiba.boot.ext.autoconfigure.core.rpc;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

/**
 * RpcContext，用于存放RPC调用时的一些上下文信息，由于使用了TransmittableThreadLocal，故上下文信息可以传递到当前线程的子线程。
 */
public class RpcContext implements Cloneable {
    //TransmittableThreadLocal?
    private static final ThreadLocal<RpcContext> LOCAL = new ThreadLocal<RpcContext>() {
        protected RpcContext initialValue() {
            return new RpcContext();
        }
    };
    /**
     * 当前rpc调用的方法
     */
    private Method method;
//    /**
//     * 当前调用RPC使用的参数
//     */
//    private Object[] arguments;
    /**
     * 当前存放的信息
     */
    private final Map<String, String> attachments = new HashMap();
    private final Map<String, Object> values = new HashMap();

    public static RpcContext getContext() {
        return LOCAL.get();
    }

    public static void setContext(RpcContext rpcContext) {
        LOCAL.set(rpcContext);
    }

    public static void removeContext() {
        LOCAL.remove();
    }

    protected RpcContext() {
    }

    @Override
    public RpcContext clone(){
        RpcContext nr = new RpcContext();
        nr.getAttachments().putAll(this.getAttachments());
        nr.get().putAll(this.get());
        nr.setMethod(this.getMethod());

        return nr;
    }

//    public Object[] getArguments() {
//        return this.arguments;
//    }
//
//    public void setArguments(Object[] arguments) {
//        this.arguments = arguments;
//    }

    public String getAttachment(String key) {
        return (String)this.attachments.get(key);
    }

    public RpcContext setAttachment(String key, String value) {
        if (value == null) {
            this.attachments.remove(key);
        } else {
            this.attachments.put(key, value);
        }

        return this;
    }

    public RpcContext removeAttachment(String key) {
        this.attachments.remove(key);
        return this;
    }

    public Map<String, String> getAttachments() {
        return this.attachments;
    }

    public RpcContext setAttachments(Map<String, String> attachment) {
        this.attachments.clear();
        if (attachment != null && attachment.size() > 0) {
            this.attachments.putAll(attachment);
        }

        return this;
    }

    public void clearAttachments() {
        this.attachments.clear();
    }

    public Map<String, Object> get() {
        return this.values;
    }

    public RpcContext set(String key, Object value) {
        if (value == null) {
            this.values.remove(key);
        } else {
            this.values.put(key, value);
        }

        return this;
    }

    public RpcContext remove(String key) {
        this.values.remove(key);
        return this;
    }

    public Object get(String key) {
        return this.values.get(key);
    }

    public Method getMethod() {
        return method;
    }

    public void setMethod(Method method) {
        this.method = method;
    }

}
