package cn.com.duiba.boot.ext.autoconfigure.core.ttl;

import cn.com.duiba.boot.ext.autoconfigure.core.SpecifiedBeanPostProcessor;
import cn.com.duiba.boot.ext.autoconfigure.threadpool.wrapper.ScheduledThreadPoolExecutorWrapper;
import cn.com.duiba.boot.ext.autoconfigure.threadpool.wrapper.ThreadPoolExecutorWrapper;
import com.alibaba.ttl.threadpool.TtlExecutors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;

import java.util.concurrent.*;

/**
 *
 *
 * 这个spring后置处理器可以把所有线程池转换为经过TransmittableThreadLocal包装的线程池
 * TransmittableThreadLocal的大概作用就是能确保子线程（包括线程池中的线程）能看到父线程的ThreadLocal的值。
 * <br/>
 * 要求所有的线程池都配置在spring上下文中。不然无法包装.
 *
 * Created by wenqi.huang on 2016/11/25.
 */
public class TransmittableExecutorBeanPostProcessor implements SpecifiedBeanPostProcessor<Executor> {

    private static Logger logger = LoggerFactory.getLogger(TransmittableExecutorBeanPostProcessor.class);

    @Override
    public Class<Executor> getBeanType() {
        return Executor.class;
    }

    @Override
    public Object postProcessBeforeInitialization(Executor bean, String beanName) throws BeansException {
        return bean;
    }

    @Override
    public Object postProcessAfterInitialization(Executor bean, String beanName) throws BeansException {
        if(bean instanceof ScheduledThreadPoolExecutorWrapper ||
                bean instanceof ThreadPoolExecutorWrapper){
            return bean;
        }
        if (bean instanceof ScheduledExecutorService) {
            bean = TtlExecutors.getTtlScheduledExecutorService((ScheduledExecutorService) bean);
        } else if (bean instanceof ExecutorService) {
            bean = TtlExecutors.getTtlExecutorService((ExecutorService) bean);
        }else if (bean instanceof Executor) {
            bean = TtlExecutors.getTtlExecutor((Executor) bean);
        }

        return bean;
    }

    @Override
    public int getOrder() {
        return 0;
    }

//    public static void main(String[] args){
//        ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(1,1,1L,TimeUnit.SECONDS,new ArrayBlockingQueue<Runnable>(10));
//        threadPoolExecutor = TtlExecutors.getTtlExecutorService(threadPoolExecutor);
//    }
}
